/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.featureflags.data;

import com.atlassian.jira.config.FeatureManager;
import com.atlassian.json.marshal.Jsonable;
import com.atlassian.pocketknife.api.featureflags.FeatureFlag;
import com.atlassian.pocketknife.api.featureflags.FeatureFlagManager;
import com.atlassian.webresource.api.data.WebResourceDataProvider;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Set;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class FeatureFlagDataProvider
implements WebResourceDataProvider {
    private FeatureFlagManager featureFlagManager;
    private FeatureManager jiraFeatureManager;

    @Autowired
    public FeatureFlagDataProvider(FeatureFlagManager featureFlagManager, FeatureManager jiraFeatureManager) {
        this.featureFlagManager = featureFlagManager;
        this.jiraFeatureManager = jiraFeatureManager;
    }

    public Jsonable get() {
        Set registeredFlags = this.featureFlagManager.getRegisteredFlags();
        HashMap featureFlagData = Maps.newHashMap();
        for (FeatureFlag featureFlag : registeredFlags) {
            featureFlagData.put(featureFlag.getFeatureKey(), featureFlag.isOnByDefault());
        }
        Set allJiraEnabledFeatures = this.jiraFeatureManager.getDarkFeatures().getAllEnabledFeatures();
        final HashMap topLevelMap = Maps.newHashMap();
        topLevelMap.put("enabled-feature-keys", allJiraEnabledFeatures);
        topLevelMap.put("feature-flag-states", featureFlagData);
        return new Jsonable(){

            public void write(Writer writer) throws IOException {
                ObjectMapper objectMapper = new ObjectMapper();
                objectMapper.configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);
                objectMapper.writeValue(writer, (Object)topLevelMap);
            }
        };
    }
}

