/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.uri;

import com.atlassian.fugue.Option;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.webhooks.api.register.listener.WebHookListenerOrigin;
import com.atlassian.webhooks.api.register.listener.WebHookListenerRegistrationDetails;
import com.atlassian.webhooks.plugin.uri.PluggableUriResolver;
import com.atlassian.webhooks.spi.UriResolver;
import com.atlassian.webhooks.spi.plugin.PluginUriResolver;
import com.google.common.base.Optional;
import java.net.URI;
import javax.inject.Named;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

@Named(value="pluggableUriResolver")
public class PluggableUriResolverImpl
implements PluggableUriResolver {
    private final BundleContext bundleContext;
    private final ApplicationProperties applicationProperties;
    private static final Logger log = LoggerFactory.getLogger(PluggableUriResolverImpl.class);

    @Autowired
    public PluggableUriResolverImpl(BundleContext bundleContext, ApplicationProperties applicationProperties) {
        this.bundleContext = bundleContext;
        this.applicationProperties = applicationProperties;
    }

    @Override
    public URI resolve(WebHookListenerRegistrationDetails listenerDetails, URI path) throws InvalidSyntaxException {
        if (listenerDetails.getOrigin() == WebHookListenerOrigin.PERSISTENT_STORE) {
            return path;
        }
        return (URI)this.resolveByPlugins(listenerDetails, path).getOrElse((Object)this.addBaseUrlIfRelative(path));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Option<URI> resolveByPlugins(WebHookListenerRegistrationDetails listenerDetails, URI path) throws InvalidSyntaxException {
        ServiceReference[] legacyServiceReferences;
        ServiceReference[] serviceReferences = this.bundleContext.getAllServiceReferences(UriResolver.class.getName(), null);
        if (serviceReferences != null) {
            for (ServiceReference serviceReference : serviceReferences) {
                try {
                    UriResolver uriResolver = (UriResolver)this.bundleContext.getService(serviceReference);
                    Option<URI> uri = this.safelyGetUriFromPluggableResolver(listenerDetails, path, uriResolver);
                    if (!uri.isDefined()) continue;
                    Option<URI> option = uri;
                    return option;
                }
                finally {
                    this.bundleContext.ungetService(serviceReference);
                }
            }
        }
        if ((legacyServiceReferences = this.bundleContext.getAllServiceReferences(PluginUriResolver.class.getName(), null)) != null) {
            for (ServiceReference serviceReference : legacyServiceReferences) {
                try {
                    Optional<URI> uri;
                    PluginUriResolver uriResolver = (PluginUriResolver)this.bundleContext.getService(serviceReference);
                    if (!listenerDetails.getModuleDescriptorDetails().isDefined() || !(uri = this.safelyGetUriFromPlugabblePluginUriResolver(listenerDetails, path, uriResolver)).isPresent()) continue;
                    Option option = Option.some((Object)uri.get());
                    return option;
                }
                finally {
                    this.bundleContext.ungetService(serviceReference);
                }
            }
        }
        return Option.none();
    }

    private Optional<URI> safelyGetUriFromPlugabblePluginUriResolver(WebHookListenerRegistrationDetails listenerDetails, URI path, PluginUriResolver uriResolver) {
        try {
            return uriResolver.getUri(((WebHookListenerRegistrationDetails.ModuleDescriptorRegistrationDetails)listenerDetails.getModuleDescriptorDetails().get()).getPluginKey(), path);
        }
        catch (RuntimeException e) {
            log.warn("uri resolver has thrown a runtime exception", (Throwable)e);
            return Optional.absent();
        }
    }

    private Option<URI> safelyGetUriFromPluggableResolver(WebHookListenerRegistrationDetails listenerDetails, URI path, UriResolver uriResolver) {
        try {
            return uriResolver.getUri(listenerDetails, path);
        }
        catch (RuntimeException e) {
            log.warn("uri resolver has thrown a runtime exception", (Throwable)e);
            return Option.none();
        }
    }

    private URI addBaseUrlIfRelative(URI path) {
        return path.toString().startsWith("/") ? URI.create(this.applicationProperties.getBaseUrl(UrlMode.CANONICAL) + path.toString()) : path;
    }
}

