/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.store;

import com.atlassian.fugue.Option;
import com.atlassian.webhooks.api.register.listener.PersistentWebHookListener;
import com.atlassian.webhooks.api.register.listener.RegistrationMethod;
import com.atlassian.webhooks.plugin.store.DefaultWebHookListenerStore;
import com.atlassian.webhooks.spi.WebHookListenerStore;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import java.util.Collection;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public class OsgiWebHookListenerStore
implements WebHookListenerStore {
    private final BundleContext bundleContext;
    private final DefaultWebHookListenerStore defaultListenerStore;

    public OsgiWebHookListenerStore(BundleContext bundleContext, DefaultWebHookListenerStore defaultListenerStore) {
        this.bundleContext = (BundleContext)Preconditions.checkNotNull((Object)bundleContext);
        this.defaultListenerStore = (DefaultWebHookListenerStore)Preconditions.checkNotNull((Object)defaultListenerStore);
    }

    @Override
    public PersistentWebHookListener addWebHook(final PersistentWebHookListener listener, final RegistrationMethod registrationMethod) {
        return this.executeStoreFunction(new Function<WebHookListenerStore, PersistentWebHookListener>(){

            public PersistentWebHookListener apply(WebHookListenerStore store) {
                return store.addWebHook(listener, registrationMethod);
            }
        });
    }

    @Override
    public PersistentWebHookListener updateWebHook(final PersistentWebHookListener webHookListener) {
        return this.executeStoreFunction(new Function<WebHookListenerStore, PersistentWebHookListener>(){

            public PersistentWebHookListener apply(WebHookListenerStore store) {
                return store.updateWebHook(webHookListener);
            }
        });
    }

    @Override
    public Option<PersistentWebHookListener> getWebHook(final int id) {
        return this.executeStoreFunction(new Function<WebHookListenerStore, Option<PersistentWebHookListener>>(){

            public Option<PersistentWebHookListener> apply(WebHookListenerStore store) {
                return store.getWebHook(id);
            }
        });
    }

    @Override
    public void removeWebHook(final int id) {
        this.executeStoreFunction(new Function<WebHookListenerStore, Void>(){

            public Void apply(WebHookListenerStore store) {
                store.removeWebHook(id);
                return null;
            }
        });
    }

    @Override
    public Collection<PersistentWebHookListener> getAllWebHooks() {
        return this.executeStoreFunction(new Function<WebHookListenerStore, Collection<PersistentWebHookListener>>(){

            public Collection<PersistentWebHookListener> apply(WebHookListenerStore store) {
                return store.getAllWebHooks();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeStoreFunction(Function<WebHookListenerStore, T> storeFunction) {
        ServiceReference serviceReference = this.bundleContext.getServiceReference(WebHookListenerStore.class.getName());
        if (serviceReference != null) {
            try {
                WebHookListenerStore webHookListenerStore = (WebHookListenerStore)this.bundleContext.getService(serviceReference);
                Object object = storeFunction.apply((Object)webHookListenerStore);
                return (T)object;
            }
            finally {
                this.bundleContext.ungetService(serviceReference);
            }
        }
        return (T)storeFunction.apply((Object)this.defaultListenerStore);
    }
}

