/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.rest;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.webhooks.api.register.listener.PersistentWebHookListener;
import com.atlassian.webhooks.api.register.listener.WebHookListenerService;
import com.atlassian.webhooks.api.register.listener.WebHookListenerServiceResponse;
import com.atlassian.webhooks.api.util.Channel;
import com.atlassian.webhooks.api.util.MessageCollection;
import com.atlassian.webhooks.plugin.api.SecuredWebHookListenerService;
import com.atlassian.webhooks.plugin.rest.ErrorCollectionBean;
import com.atlassian.webhooks.plugin.rest.WebHookListenerJsonBean;
import com.atlassian.webhooks.plugin.rest.WebHookListenerResponseBean;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.net.URI;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;

@Path(value="webhook")
@Produces(value={"application/json"})
public class WebHookListenerResource {
    private final UserManager userManager;
    private final SecuredWebHookListenerService webHookListenerService;

    public WebHookListenerResource(UserManager userManager, SecuredWebHookListenerService webHookListenerService) {
        this.webHookListenerService = (SecuredWebHookListenerService)Preconditions.checkNotNull((Object)webHookListenerService);
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
    }

    @GET
    public Response getAllListeners(final @Context UriInfo uriInfo) {
        Iterable<PersistentWebHookListener> allWebHookListeners = this.webHookListenerService.getAllWebHookListeners(Channel.REST);
        return Response.ok((Object)Iterables.transform(allWebHookListeners, (Function)new Function<PersistentWebHookListener, WebHookListenerResponseBean>(){

            public WebHookListenerResponseBean apply(PersistentWebHookListener webHook) {
                URI self = uriInfo.getAbsolutePathBuilder().path(String.valueOf(webHook.getId().get())).build(new Object[0]);
                return new WebHookListenerResponseBean.Factory(WebHookListenerResource.this.userManager).create(webHook, self);
            }
        })).build();
    }

    @POST
    @Consumes(value={"application/json"})
    public Response register(WebHookListenerJsonBean registration, final @Context UriInfo uriInfo, @DefaultValue(value="false") @QueryParam(value="ui") boolean registeredViaUI) {
        WebHookListenerServiceResponse webHookListenerServiceResponse = this.webHookListenerService.registerWebHookListener(registeredViaUI ? Channel.UI : Channel.REST, registration.toRegisteredWebHookListener());
        return webHookListenerServiceResponse.fold(new Function<MessageCollection, Response>(){

            public Response apply(MessageCollection messageCollection) {
                return WebHookListenerResource.this.fromMessageCollection(messageCollection);
            }
        }, new Function<PersistentWebHookListener, Response>(){

            public Response apply(PersistentWebHookListener listener) {
                URI uri = uriInfo.getAbsolutePathBuilder().path(String.valueOf(listener.getId().get())).build(new Object[0]);
                return Response.created((URI)uri).entity((Object)new WebHookListenerResponseBean.Factory(WebHookListenerResource.this.userManager).create(listener, uri)).build();
            }
        });
    }

    @GET
    @Path(value="{id}")
    public Response getListener(@PathParam(value="id") int id, final @Context UriInfo uriInfo) {
        return (Response)this.webHookListenerService.getWebHookListener(Channel.REST, id).fold((Supplier)new Supplier<Response>(){

            public Response get() {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
        }, (Function)new Function<PersistentWebHookListener, Response>(){

            public Response apply(PersistentWebHookListener listener) {
                URI self = uriInfo.getAbsolutePath();
                return Response.ok((Object)new WebHookListenerResponseBean.Factory(WebHookListenerResource.this.userManager).create(listener, self)).build();
            }
        });
    }

    @PUT
    @Path(value="{id}")
    @Consumes(value={"application/json"})
    public Response update(@PathParam(value="id") int id, WebHookListenerJsonBean registration, final @Context UriInfo uriInfo) {
        return this.webHookListenerService.updateWebHookListener(Channel.REST, id, this.updateInput(registration)).fold(new Function<MessageCollection, Response>(){

            public Response apply(MessageCollection messageCollection) {
                return WebHookListenerResource.this.fromMessageCollection(messageCollection);
            }
        }, new Function<PersistentWebHookListener, Response>(){

            public Response apply(PersistentWebHookListener listener) {
                URI self = uriInfo.getAbsolutePath();
                return Response.ok((Object)new WebHookListenerResponseBean.Factory(WebHookListenerResource.this.userManager).create(listener, self)).build();
            }
        });
    }

    @DELETE
    @Path(value="{id}")
    public Response deleteListener(@PathParam(value="id") int id) {
        MessageCollection messageCollection = this.webHookListenerService.deleteWebHookListener(Channel.REST, id);
        if (messageCollection.isEmpty()) {
            return Response.noContent().build();
        }
        return this.fromMessageCollection(messageCollection);
    }

    private Response fromMessageCollection(MessageCollection messageCollection) {
        return Response.status((int)MessageCollection.Reason.getWorstReason(messageCollection.getReasons()).getHttpStatusCode()).entity((Object)new ErrorCollectionBean(messageCollection)).build();
    }

    private WebHookListenerService.WebHookListenerUpdateInput updateInput(WebHookListenerJsonBean bean) {
        return WebHookListenerService.WebHookListenerUpdateInput.builder().setDescription(bean.getDescription()).setName(bean.getName()).setEnabled(bean.isEnabled()).setEvents(bean.getEvents()).setFilters(bean.getFilters()).setExcludeBody(bean.isExcludeBody()).setUrl(bean.getUrl()).build();
    }
}

