/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.module;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.atlassian.util.concurrent.ResettableLazyReference;
import com.atlassian.webhooks.api.register.RegisteredWebHookEvent;
import com.atlassian.webhooks.api.register.WebHookEventGroup;
import com.atlassian.webhooks.api.register.WebHookEventSection;
import com.atlassian.webhooks.api.register.WebHookPluginRegistration;
import com.atlassian.webhooks.plugin.module.ClassSpecificProcessors;
import com.atlassian.webhooks.plugin.module.ModuleKey;
import com.atlassian.webhooks.plugin.module.WebHookPluginRegistrationContainer;
import com.atlassian.webhooks.plugin.module.WebHookRegistrationFactoryModuleDescriptor;
import com.atlassian.webhooks.plugin.module.WebHookRegistry;
import com.atlassian.webhooks.spi.EventSerializer;
import com.atlassian.webhooks.spi.RequestSigner;
import com.atlassian.webhooks.spi.RequestSigner2;
import com.atlassian.webhooks.spi.UriVariablesProvider;
import com.atlassian.webhooks.spi.WebHookListenerActionValidator;
import com.atlassian.webhooks.spi.WebHookPluginRegistrationFactory;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Autowired;

@Named(value="webHookPluginRegistrationContainer")
public class WebHookPluginRegistrationContainerImpl
implements WebHookPluginRegistrationContainer {
    private final WebHookRegistry webHookRegistry = new WebHookRegistry();
    private final ConcurrentMap<ModuleKey, WebHookPluginRegistration> cachedRegistrations = new ConcurrentHashMap<ModuleKey, WebHookPluginRegistration>();
    private final ResettableLazyReference<Set<WebHookPluginRegistration>> webHookRegistrations;
    private final ResettableLazyReference<ClassSpecificProcessors<EventSerializer>> eventSerializers;
    private final ResettableLazyReference<ClassSpecificProcessors<UriVariablesProvider>> uriVariablesProviders;
    private final ResettableLazyReference<List<WebHookEventSection>> webHookSection;
    private final ResettableLazyReference<Set<RequestSigner>> requestSigners;
    private final ResettableLazyReference<Set<RequestSigner2>> requestSigners2;
    private final ResettableLazyReference<Iterable<WebHookListenerActionValidator>> validators;
    @VisibleForTesting
    final DefaultPluginModuleTracker<WebHookPluginRegistrationFactory, WebHookRegistrationFactoryModuleDescriptor> tracker;

    @Autowired
    public WebHookPluginRegistrationContainerImpl(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        this.tracker = new DefaultPluginModuleTracker(pluginAccessor, pluginEventManager, WebHookRegistrationFactoryModuleDescriptor.class, (PluginModuleTracker.Customizer)new PluginModuleTracker.Customizer<WebHookPluginRegistrationFactory, WebHookRegistrationFactoryModuleDescriptor>(){

            public WebHookRegistrationFactoryModuleDescriptor adding(WebHookRegistrationFactoryModuleDescriptor descriptor) {
                ModuleKey moduleKey = ModuleKey.of(descriptor);
                WebHookPluginRegistration pluginRegistration = descriptor.getModule().createPluginRegistration();
                WebHookPluginRegistrationContainerImpl.this.addRegistration(moduleKey, pluginRegistration);
                return descriptor;
            }

            public void removed(WebHookRegistrationFactoryModuleDescriptor descriptor) {
                ModuleKey moduleKey = ModuleKey.of(descriptor);
                WebHookPluginRegistrationContainerImpl.this.removeRegistration(moduleKey);
            }
        });
        this.webHookRegistrations = new ResettableLazyReference<Set<WebHookPluginRegistration>>(){

            protected Set<WebHookPluginRegistration> create() throws Exception {
                return ImmutableSet.copyOf(WebHookPluginRegistrationContainerImpl.this.cachedRegistrations.values());
            }
        };
        this.eventSerializers = this.getReferenceToProcessors("Event Serializer", new Function<WebHookPluginRegistration, Map<Class, EventSerializer>>(){

            public Map<Class, EventSerializer> apply(WebHookPluginRegistration registration) {
                return registration.getEventSerializers();
            }
        });
        this.uriVariablesProviders = this.getReferenceToProcessors("Uri Variable Provider", new Function<WebHookPluginRegistration, Map<Class, UriVariablesProvider>>(){

            public Map<Class, UriVariablesProvider> apply(WebHookPluginRegistration registration) {
                return registration.getUriVariablesProviders();
            }
        });
        this.webHookSection = new ResettableLazyReference<List<WebHookEventSection>>(){

            protected List<WebHookEventSection> create() throws Exception {
                return ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(WebHookPluginRegistrationContainerImpl.this.cachedRegistrations.values(), (Function)new Function<WebHookPluginRegistration, List<WebHookEventSection>>(){

                    public List<WebHookEventSection> apply(WebHookPluginRegistration webHookPluginRegistration) {
                        return webHookPluginRegistration.getSections();
                    }
                })));
            }
        };
        this.requestSigners = new ResettableLazyReference<Set<RequestSigner>>(){

            protected Set<RequestSigner> create() throws Exception {
                return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(WebHookPluginRegistrationContainerImpl.this.cachedRegistrations.values(), (Function)new Function<WebHookPluginRegistration, Set<RequestSigner>>(){

                    public Set<RequestSigner> apply(WebHookPluginRegistration registration) {
                        return registration.getRequestSigners();
                    }
                })));
            }
        };
        this.requestSigners2 = new ResettableLazyReference<Set<RequestSigner2>>(){

            protected Set<RequestSigner2> create() throws Exception {
                return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(WebHookPluginRegistrationContainerImpl.this.cachedRegistrations.values(), (Function)new Function<WebHookPluginRegistration, Set<RequestSigner2>>(){

                    public Set<RequestSigner2> apply(WebHookPluginRegistration registration) {
                        return registration.getRequestSigners2();
                    }
                })));
            }
        };
        this.validators = new ResettableLazyReference<Iterable<WebHookListenerActionValidator>>(){

            protected Iterable<WebHookListenerActionValidator> create() throws Exception {
                return ImmutableSet.copyOf((Iterable)Iterables.concat((Iterable)Iterables.transform(WebHookPluginRegistrationContainerImpl.this.cachedRegistrations.values(), (Function)new Function<WebHookPluginRegistration, Set<WebHookListenerActionValidator>>(){

                    public Set<WebHookListenerActionValidator> apply(WebHookPluginRegistration registration) {
                        return registration.getValidators();
                    }
                })));
            }
        };
    }

    @Override
    public void removeRegistration(ModuleKey moduleKey) {
        this.cachedRegistrations.remove(moduleKey);
        this.webHookRegistry.remove(moduleKey);
        this.resetLazyReferences();
    }

    @Override
    public void addRegistration(ModuleKey moduleKey, WebHookPluginRegistration pluginRegistration) {
        this.cachedRegistrations.put(moduleKey, pluginRegistration);
        this.webHookRegistry.add(moduleKey, (WebHookPluginRegistration)this.cachedRegistrations.get(moduleKey));
        this.resetLazyReferences();
    }

    private <T> ResettableLazyReference<ClassSpecificProcessors<T>> getReferenceToProcessors(final String name, final Function<WebHookPluginRegistration, Map<Class, T>> getProcessors) {
        return new ResettableLazyReference<ClassSpecificProcessors<T>>(){

            protected ClassSpecificProcessors<T> create() throws Exception {
                return WebHookPluginRegistrationContainerImpl.this.getProcessors(name, getProcessors);
            }
        };
    }

    private <T> ClassSpecificProcessors<T> getProcessors(String name, Function<WebHookPluginRegistration, Map<Class, T>> getProcessors) {
        ClassSpecificProcessors.Builder processors = ClassSpecificProcessors.builder(name);
        for (WebHookPluginRegistration registration : this.cachedRegistrations.values()) {
            for (Map.Entry processorEntry : ((Map)getProcessors.apply((Object)registration)).entrySet()) {
                processors.add((Class)processorEntry.getKey(), processorEntry.getValue());
            }
        }
        return processors.build();
    }

    @Override
    public Set<WebHookPluginRegistration> getWebHookRegistrations() {
        return (Set)this.webHookRegistrations.get();
    }

    @Override
    public ClassSpecificProcessors<EventSerializer> getEventSerializers() {
        return (ClassSpecificProcessors)this.eventSerializers.get();
    }

    @Override
    public ClassSpecificProcessors<UriVariablesProvider> getUriVariablesProviders() {
        return (ClassSpecificProcessors)this.uriVariablesProviders.get();
    }

    @Override
    public WebHookRegistry getWebHookRegistry() {
        return this.webHookRegistry;
    }

    @Override
    public List<WebHookEventSection> getWebHookSections() {
        return (List)this.webHookSection.get();
    }

    @Override
    public Set<RequestSigner> getRequestSigners() {
        return (Set)this.requestSigners.get();
    }

    @Override
    public Set<RequestSigner2> getRequestSigners2() {
        return (Set)this.requestSigners2.get();
    }

    @Override
    public Iterable<RegisteredWebHookEvent> getAllWebhooks() {
        return Iterables.concat((Iterable)Iterables.transform(this.getWebHookSections(), (Function)new Function<WebHookEventSection, Iterable<RegisteredWebHookEvent>>(){

            public Iterable<RegisteredWebHookEvent> apply(WebHookEventSection input) {
                return Iterables.concat((Iterable)Iterables.transform(input.getGroups(), (Function)new Function<WebHookEventGroup, Iterable<RegisteredWebHookEvent>>(){

                    public Iterable<RegisteredWebHookEvent> apply(WebHookEventGroup input) {
                        return input.getEvents();
                    }
                }));
            }
        }));
    }

    @Override
    public Iterable<WebHookListenerActionValidator> getValidators() {
        return (Iterable)this.validators.get();
    }

    private void resetLazyReferences() {
        this.webHookRegistrations.reset();
        this.eventSerializers.reset();
        this.uriVariablesProviders.reset();
        this.webHookSection.reset();
        this.requestSigners.reset();
        this.validators.reset();
    }
}

