/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.module;

import com.atlassian.webhooks.api.publish.WebHookEvent;
import com.atlassian.webhooks.api.register.listener.WebHookListener;
import com.atlassian.webhooks.api.util.EventSerializers;
import com.atlassian.webhooks.plugin.module.WebHookPluginRegistrationContainer;
import com.atlassian.webhooks.spi.EventSerializer;
import com.google.common.annotations.VisibleForTesting;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="webHookEventSerializer")
public class WebHookEventSerializer {
    private final WebHookPluginRegistrationContainer container;

    @Inject
    public WebHookEventSerializer(WebHookPluginRegistrationContainer container) {
        this.container = container;
    }

    public String serialize(WebHookEvent webHookEvent, WebHookListener listener) {
        if (listener.getParameters().isExcludeBody()) {
            return "";
        }
        EventSerializer<?> serializer = this.serializerFor(webHookEvent.getEvent().getClass());
        return serializer.serialize(webHookEvent.getEvent());
    }

    @VisibleForTesting
    <T> EventSerializer<? super T> serializerFor(Class<T> eventClass) {
        return (EventSerializer)this.container.getEventSerializers().forType(eventClass).or(EventSerializers.REFLECTION);
    }
}

