/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.module;

import com.atlassian.webhooks.api.register.WebHookPluginRegistration;
import com.atlassian.webhooks.plugin.module.CloudConditionResolver;
import com.atlassian.webhooks.plugin.module.WebHookPluginRegistrationContainer;
import com.atlassian.webhooks.spi.WebHookPluginRegistrationFactory;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import javax.inject.Named;
import org.springframework.beans.factory.annotation.Autowired;

@Named(value="cloudConditionResolver")
public class CloudConditionResolverImpl
implements CloudConditionResolver {
    private final WebHookPluginRegistrationContainer container;

    @Autowired
    public CloudConditionResolverImpl(WebHookPluginRegistrationContainer container) {
        this.container = container;
    }

    @Override
    public boolean isCloud() {
        Iterable webHookRegistrationsWithCloudCondition = Iterables.filter(this.container.getWebHookRegistrations(), (Predicate)new Predicate<WebHookPluginRegistration>(){

            public boolean apply(WebHookPluginRegistration registration) {
                return registration.getCloudCondition().isDefined();
            }
        });
        if (Iterables.isEmpty((Iterable)webHookRegistrationsWithCloudCondition)) {
            return false;
        }
        return Iterables.all((Iterable)webHookRegistrationsWithCloudCondition, (Predicate)new Predicate<WebHookPluginRegistration>(){

            public boolean apply(WebHookPluginRegistration registration) {
                return ((WebHookPluginRegistrationFactory.CloudCondition)registration.getCloudCondition().get()).isCloud();
            }
        });
    }
}

