/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.module;

import com.atlassian.webhooks.plugin.util.ClassInfo;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Map;

public class ClassSpecificProcessors<T> {
    private final Map<Class, T> map;
    private final String name;

    @VisibleForTesting
    ClassSpecificProcessors(Map<Class, T> map) {
        this(map, "Processor");
    }

    @VisibleForTesting
    private ClassSpecificProcessors(Map<Class, T> map, String name) {
        this.map = ImmutableMap.copyOf(map);
        this.name = name;
    }

    public static <T> Builder<T> builder(String processorName) {
        return new Builder(processorName);
    }

    public Optional<T> forType(Class<?> type) {
        for (ClassInfo.HierarchyLevel hierarchyHierarchyLevel : ClassInfo.of(type).typeHierarchy()) {
            Sets.SetView matching = Sets.intersection(hierarchyHierarchyLevel.getTypes(), this.map.keySet());
            if (matching.size() > 1) {
                throw new IllegalStateException(String.format("Don't know what to choose for %s, %ss are registered for the following types: %s", type, this.name, matching));
            }
            if (matching.size() != 1) continue;
            return Optional.of(this.map.get(matching.iterator().next()));
        }
        return Optional.absent();
    }

    public Iterable<T> allForType(final Class<?> type) {
        return Iterables.transform((Iterable)Iterables.filter(this.map.entrySet(), (Predicate)new Predicate<Map.Entry<Class, T>>(){

            public boolean apply(Map.Entry<Class, T> input) {
                return input.getKey().isAssignableFrom(type);
            }
        }), (Function)new Function<Map.Entry<Class, T>, T>(){

            public T apply(Map.Entry<Class, T> input) {
                return input.getValue();
            }
        });
    }

    static class Builder<T> {
        private final Map<Class, T> builder = Maps.newHashMap();
        private final String processorName;

        private Builder(String processorName) {
            this.processorName = processorName;
        }

        public Builder<T> add(Class type, T processor) {
            Class<?> newProcessor;
            Class<?> registeredProcessor;
            if (this.builder.containsKey(type) && !(registeredProcessor = this.builder.get(type).getClass()).equals(newProcessor = processor.getClass())) {
                throw new IllegalStateException(String.format("Tried to register two %ss (%s and %s) for event class %s", this.processorName, registeredProcessor.getName(), newProcessor.getName(), type) + ", but at the moment only one \" + processorName + \" per event class is supported\")");
            }
            this.builder.put(type, processor);
            return this;
        }

        public ClassSpecificProcessors<T> build() {
            return new ClassSpecificProcessors(this.builder, this.processorName);
        }
    }
}

