/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.impl;

import com.atlassian.fugue.Effect;
import com.atlassian.httpclient.api.Request;
import com.atlassian.osgi.tracker.WaitableServiceTrackerCustomizer;
import com.atlassian.osgi.tracker.WaitableServiceTrackerFactory;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.webhooks.api.register.listener.WebHookListenerRegistrationDetails;
import com.atlassian.webhooks.plugin.module.WebHookPluginRegistrationContainer;
import com.atlassian.webhooks.spi.RequestSigner2;
import com.atlassian.webhooks.spi.plugin.RequestSigner;
import com.google.common.annotations.VisibleForTesting;
import java.net.URI;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="requestSigner")
public final class RequestSignerImpl
implements RequestSigner2 {
    private final WebHookPluginRegistrationContainer container;
    private final Set<RequestSigner> legacyRequestSigners;
    private final RequestSignerWaitableServiceTrackerCustomizer tracker;

    @Inject
    public RequestSignerImpl(WaitableServiceTrackerFactory factory, WebHookPluginRegistrationContainer container) {
        this.container = container;
        this.legacyRequestSigners = new HashSet<RequestSigner>();
        this.tracker = new RequestSignerWaitableServiceTrackerCustomizer();
        factory.create(RequestSigner.class, this.tracker);
    }

    @Override
    public void sign(final URI uri, Optional<UserProfile> userProfile, WebHookListenerRegistrationDetails registrationDetails, final Request.Builder request) {
        for (com.atlassian.webhooks.spi.RequestSigner requestSigner : this.container.getRequestSigners()) {
            requestSigner.sign(uri, registrationDetails, request);
        }
        for (RequestSigner2 requestSigner2 : this.container.getRequestSigners2()) {
            requestSigner2.sign(uri, userProfile, registrationDetails, request);
        }
        for (final RequestSigner legacyRequestSigner : this.legacyRequestSigners) {
            registrationDetails.getModuleDescriptorDetails().foreach((Effect)new Effect<WebHookListenerRegistrationDetails.ModuleDescriptorRegistrationDetails>(){

                public void apply(WebHookListenerRegistrationDetails.ModuleDescriptorRegistrationDetails moduleDescriptorRegistrationDetails) {
                    legacyRequestSigner.sign(uri, moduleDescriptorRegistrationDetails.getPluginKey(), request);
                }
            });
        }
    }

    @VisibleForTesting
    public RequestSignerWaitableServiceTrackerCustomizer getTracker() {
        return this.tracker;
    }

    @VisibleForTesting
    public class RequestSignerWaitableServiceTrackerCustomizer
    implements WaitableServiceTrackerCustomizer<RequestSigner> {
        @Override
        public RequestSigner adding(RequestSigner requestSigner) {
            RequestSignerImpl.this.legacyRequestSigners.add(requestSigner);
            return requestSigner;
        }

        @Override
        public void removed(RequestSigner requestSigner) {
            RequestSignerImpl.this.legacyRequestSigners.remove(requestSigner);
        }
    }
}

