/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin.api;

import com.atlassian.fugue.Effect;
import com.atlassian.fugue.Option;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.webhooks.api.register.listener.PersistentWebHookListener;
import com.atlassian.webhooks.api.register.listener.WebHookListenerService;
import com.atlassian.webhooks.api.register.listener.WebHookListenerServiceResponse;
import com.atlassian.webhooks.api.util.Channel;
import com.atlassian.webhooks.api.util.ListenerDuplicatePredicate;
import com.atlassian.webhooks.api.util.MessageCollection;
import com.atlassian.webhooks.plugin.api.SecuredWebHookListenerService;
import com.atlassian.webhooks.plugin.event.WebHookEventDispatcher;
import com.atlassian.webhooks.plugin.store.WebHookListenerCachingStore;
import com.atlassian.webhooks.spi.WebHookListenerAccessVoter;
import com.atlassian.webhooks.spi.WebHookListenerActionValidator;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import java.io.Serializable;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Named;

@Named(value="securedWebHookListenerService")
public class SecuredWebHookListenerServiceImpl
implements SecuredWebHookListenerService {
    private final WebHookListenerAccessVoter accessVoter;
    private final I18nResolver i18n;
    private final WebHookListenerActionValidator webHookListenerActionValidator;
    private final WebHookListenerCachingStore webHookListenerCachingStore;
    private final WebHookEventDispatcher webHookEventDispatcher;

    @Inject
    public SecuredWebHookListenerServiceImpl(WebHookListenerAccessVoter accessVoter, I18nResolver i18nResolver, WebHookListenerActionValidator webHookListenerActionValidator, WebHookListenerCachingStore webHookListenerCachingStore, WebHookEventDispatcher webHookEventDispatcher) {
        this.accessVoter = (WebHookListenerAccessVoter)Preconditions.checkNotNull((Object)accessVoter, (Object)"accessVoter");
        this.i18n = (I18nResolver)Preconditions.checkNotNull((Object)i18nResolver, (Object)"i18nResolver");
        this.webHookListenerActionValidator = (WebHookListenerActionValidator)Preconditions.checkNotNull((Object)webHookListenerActionValidator, (Object)"webHookListenerActionValidator");
        this.webHookListenerCachingStore = (WebHookListenerCachingStore)Preconditions.checkNotNull((Object)webHookListenerCachingStore, (Object)"webHookListenerCachingStore");
        this.webHookEventDispatcher = (WebHookEventDispatcher)Preconditions.checkNotNull((Object)webHookEventDispatcher, (Object)"webHookEventDispatcher");
    }

    @Override
    public Iterable<PersistentWebHookListener> getAllWebHookListeners(final @Nonnull Channel channel) {
        Preconditions.checkNotNull((Object)((Object)channel), (Object)"channel");
        return Iterables.filter(this.webHookListenerCachingStore.getAllWebHookListeners(), (Predicate)new Predicate<PersistentWebHookListener>(){

            public boolean apply(PersistentWebHookListener input) {
                return SecuredWebHookListenerServiceImpl.this.accessVoter.canRead(input, channel).isAllowed();
            }
        });
    }

    @Override
    public Option<PersistentWebHookListener> getWebHookListener(final @Nonnull Channel channel, int id) {
        Preconditions.checkNotNull((Object)((Object)channel), (Object)"channel");
        return this.webHookListenerCachingStore.getWebHookListener((Integer)Preconditions.checkNotNull((Object)id, (Object)"id")).flatMap((Function)new Function<PersistentWebHookListener, Option<PersistentWebHookListener>>(){

            public Option<PersistentWebHookListener> apply(PersistentWebHookListener webHookListener) {
                return SecuredWebHookListenerServiceImpl.this.accessVoter.canRead(webHookListener, channel).isAllowed() ? Option.some((Object)webHookListener) : Option.none();
            }
        });
    }

    @Override
    public WebHookListenerServiceResponse registerWebHookListener(@Nonnull Channel channel, @Nonnull PersistentWebHookListener listener) {
        Preconditions.checkNotNull((Object)((Object)channel), (Object)"channel");
        Preconditions.checkNotNull((Object)listener, (Object)"listener");
        MessageCollection messageCollection = this.validateCreateWebHookListener(channel, listener);
        if (!messageCollection.isEmpty()) {
            return WebHookListenerServiceResponse.error(messageCollection);
        }
        PersistentWebHookListener registeredListener = this.webHookListenerCachingStore.registerWebHookListener(listener, channel.toRegistrationMethod());
        this.webHookEventDispatcher.webHookCreated(registeredListener, channel.toRegistrationMethod());
        return WebHookListenerServiceResponse.ok(registeredListener);
    }

    @Override
    public WebHookListenerServiceResponse updateWebHookListener(final @Nonnull Channel channel, final int id, final @Nonnull WebHookListenerService.WebHookListenerUpdateInput listenerUpdateParams) {
        Preconditions.checkNotNull((Object)((Object)channel), (Object)"channel");
        Preconditions.checkNotNull((Object)listenerUpdateParams, (Object)"listener");
        return (WebHookListenerServiceResponse)this.getWebHookListener(channel, id).fold((Supplier)new Supplier<WebHookListenerServiceResponse>(){

            public WebHookListenerServiceResponse get() {
                return WebHookListenerServiceResponse.error(MessageCollection.of(SecuredWebHookListenerServiceImpl.this.i18n.getText("webhooks.does.not.exist", new Serializable[]{Integer.valueOf(id)}), MessageCollection.Reason.NOT_FOUND));
            }
        }, (Function)new Function<PersistentWebHookListener, WebHookListenerServiceResponse>(){

            public WebHookListenerServiceResponse apply(PersistentWebHookListener existingListener) {
                PersistentWebHookListener listenerToUpdate = SecuredWebHookListenerServiceImpl.this.createListenerToUpdate(existingListener, listenerUpdateParams);
                MessageCollection messageCollection = SecuredWebHookListenerServiceImpl.this.validateUpdateWebHookListener(channel, listenerToUpdate);
                if (!messageCollection.isEmpty()) {
                    return WebHookListenerServiceResponse.error(messageCollection);
                }
                PersistentWebHookListener updatedListener = SecuredWebHookListenerServiceImpl.this.webHookListenerCachingStore.updateWebHookListener(listenerToUpdate);
                SecuredWebHookListenerServiceImpl.this.webHookEventDispatcher.webHookEdited(updatedListener, channel.toRegistrationMethod());
                return WebHookListenerServiceResponse.ok(updatedListener);
            }
        });
    }

    @Override
    public MessageCollection deleteWebHookListener(@Nonnull Channel channel, int id) {
        Preconditions.checkNotNull((Object)((Object)channel), (Object)"channel");
        Option<PersistentWebHookListener> webHookListener = this.getWebHookListener(channel, id);
        MessageCollection messageCollection = this.validateDeleteWebHookListener(channel, id, webHookListener);
        if (messageCollection.isEmpty()) {
            this.webHookListenerCachingStore.removeWebHookListener(id);
            this.webHookEventDispatcher.webHookDeleted((PersistentWebHookListener)webHookListener.get(), channel.toRegistrationMethod());
        }
        return messageCollection;
    }

    private MessageCollection validateCreateWebHookListener(@Nonnull Channel channel, @Nonnull PersistentWebHookListener listener) {
        if (!this.accessVoter.canCreate(listener, channel).isAllowed()) {
            return MessageCollection.of(this.i18n.getText("webhooks.create.insufficient.privileges", new Serializable[]{listener.getName()}), MessageCollection.Reason.FORBIDDEN);
        }
        final MessageCollection.Builder builder = MessageCollection.builder();
        this.validateUniqueRegistration(listener).foreach((Effect)new Effect<MessageCollection>(){

            public void apply(MessageCollection messageCollection) {
                builder.addAll(messageCollection);
            }
        });
        builder.addAll(this.webHookListenerActionValidator.validateWebHookRegistration(listener));
        return builder.build();
    }

    private MessageCollection validateUpdateWebHookListener(Channel channel, PersistentWebHookListener listener) {
        final MessageCollection.Builder builder = MessageCollection.builder();
        this.validateUniqueRegistration((PersistentWebHookListener)Preconditions.checkNotNull((Object)listener, (Object)"listener")).foreach((Effect)new Effect<MessageCollection>(){

            public void apply(MessageCollection messageCollection) {
                builder.addAll(messageCollection);
            }
        });
        builder.addAll(this.webHookListenerActionValidator.validateWebHookUpdate(listener));
        if (!this.canAdmin(channel, (Integer)listener.getId().get())) {
            builder.addMessage(this.i18n.getText("webhooks.update.insufficient.privileges", new Serializable[]{listener.getName()}), MessageCollection.Reason.FORBIDDEN);
        }
        return builder.build();
    }

    private MessageCollection validateDeleteWebHookListener(@Nonnull Channel channel, int id, @Nonnull Option<PersistentWebHookListener> webHookListener) {
        if (webHookListener.isEmpty()) {
            return MessageCollection.of(this.i18n.getText("webhooks.does.not.exist", new Serializable[]{Integer.valueOf(id)}), MessageCollection.Reason.NOT_FOUND);
        }
        MessageCollection.Builder builder = MessageCollection.builder();
        builder.addAll(this.webHookListenerActionValidator.validateWebHookRemoval((PersistentWebHookListener)webHookListener.get()));
        if (!this.accessVoter.canAdmin((PersistentWebHookListener)webHookListener.get(), channel).isAllowed()) {
            builder.addMessage(this.i18n.createMessage("webhooks.delete.insufficient.privileges", new Serializable[]{((PersistentWebHookListener)webHookListener.get()).getName()}), MessageCollection.Reason.FORBIDDEN);
        }
        return builder.build();
    }

    private boolean canAdmin(Channel channel, int id) {
        Option<PersistentWebHookListener> parameters = this.getWebHookListener(channel, id);
        return parameters.isDefined() && this.accessVoter.canAdmin((PersistentWebHookListener)parameters.get(), channel).isAllowed();
    }

    private PersistentWebHookListener createListenerToUpdate(PersistentWebHookListener existingListener, WebHookListenerService.WebHookListenerUpdateInput listenerUpdateParams) {
        PersistentWebHookListener.Builder updatedListenerBuilder = PersistentWebHookListener.existing((Integer)existingListener.getId().get()).setEnabled((Boolean)listenerUpdateParams.getEnabled().getOrElse((Object)existingListener.isEnabled())).setUrl((String)listenerUpdateParams.getUrl().getOrElse((Object)existingListener.getUrl())).setListenerName((String)listenerUpdateParams.getName().getOrElse((Object)existingListener.getName())).setDescription((String)listenerUpdateParams.getDescription().getOrElse((Object)existingListener.getDescription())).setExcludeBody((Boolean)listenerUpdateParams.getExcludeBody().getOrElse((Object)existingListener.isExcludeBody())).addWebHookIds((Collection)listenerUpdateParams.getEvents().getOrElse(existingListener.getEvents()));
        if (listenerUpdateParams.getFilters().isDefined()) {
            updatedListenerBuilder.addFilters((Map)listenerUpdateParams.getFilters().get());
        } else {
            updatedListenerBuilder.addFiltersTypeRich(existingListener.getFilters());
        }
        return updatedListenerBuilder.build();
    }

    private Option<MessageCollection> validateUniqueRegistration(PersistentWebHookListener listener) {
        return Option.option((Object)Iterables.find(this.webHookListenerCachingStore.getAllWebHookListeners(), ListenerDuplicatePredicate.duplicateOf(listener), null)).flatMap((Function)new Function<PersistentWebHookListener, Option<? extends MessageCollection>>(){

            public Option<? extends MessageCollection> apply(PersistentWebHookListener listener) {
                return Option.some((Object)MessageCollection.of(SecuredWebHookListenerServiceImpl.this.i18n.getText("webhooks.submit.duplicate.info"), MessageCollection.Reason.CONFLICT));
            }
        });
    }
}

