/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.webhooks.api.events.WebHookPublishedEvent;
import com.atlassian.webhooks.api.events.WebHookRejectedEvent;
import com.atlassian.webhooks.api.publish.WebHookEvent;
import com.atlassian.webhooks.api.register.listener.WebHookListener;
import com.atlassian.webhooks.api.util.Vote;
import com.atlassian.webhooks.plugin.PublishTask;
import com.atlassian.webhooks.plugin.PublishTaskFactory;
import com.atlassian.webhooks.plugin.WebHookListenerProvider;
import com.atlassian.webhooks.plugin.WebHookPublisher;
import com.atlassian.webhooks.plugin.legacy.LegacyEventMatcher;
import com.atlassian.webhooks.plugin.legacy.LegacyListener;
import com.atlassian.webhooks.plugin.legacy.LegacyModuleDescriptorWebHookListenerRegistryImpl;
import com.atlassian.webhooks.spi.WebHookListenerAccessVoter;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class WebHookPublisherImpl
implements WebHookPublisher {
    private static final int PUBLISH_QUEUE_SIZE = 100;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final WebHookListenerAccessVoter accessVoter;
    private final WebHookListenerProvider listenerProvider;
    private final PublishTaskFactory publishTaskFactory;
    private final EventPublisher eventPublisher;
    private final Executor executor;
    private final LegacyModuleDescriptorWebHookListenerRegistryImpl legacyListeners;
    private final boolean ownExecutor;

    public WebHookPublisherImpl(WebHookListenerAccessVoter accessVoter, WebHookListenerProvider listenerProvider, PublishTaskFactory publishTaskFactory, EventPublisher eventPublisher, LegacyModuleDescriptorWebHookListenerRegistryImpl legacyListeners) {
        this(accessVoter, listenerProvider, publishTaskFactory, eventPublisher, legacyListeners, new ThreadPoolExecutor(3, 3, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(100), new ThreadFactoryBuilder().setNameFormat("Web-Hook-Publisher-%d").setDaemon(true).build()), true);
    }

    public WebHookPublisherImpl(WebHookListenerAccessVoter accessVoter, WebHookListenerProvider listenerProvider, PublishTaskFactory publishTaskFactory, EventPublisher eventPublisher, LegacyModuleDescriptorWebHookListenerRegistryImpl legacyListeners, Executor executor) {
        this(accessVoter, listenerProvider, publishTaskFactory, eventPublisher, legacyListeners, executor, false);
    }

    WebHookPublisherImpl(WebHookListenerAccessVoter accessVoter, WebHookListenerProvider listenerProvider, PublishTaskFactory publishTaskFactory, EventPublisher eventPublisher, LegacyModuleDescriptorWebHookListenerRegistryImpl legacyListeners, Executor executor, boolean ownExecutor) {
        this.accessVoter = (WebHookListenerAccessVoter)Preconditions.checkNotNull((Object)accessVoter, (Object)"accessVoter");
        this.listenerProvider = (WebHookListenerProvider)Preconditions.checkNotNull((Object)listenerProvider, (Object)"listenerProvider");
        this.publishTaskFactory = (PublishTaskFactory)Preconditions.checkNotNull((Object)publishTaskFactory, (Object)"publishTaskFactory");
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher, (Object)"eventPublisher");
        this.legacyListeners = (LegacyModuleDescriptorWebHookListenerRegistryImpl)Preconditions.checkNotNull((Object)legacyListeners, (Object)"legacyListeners");
        this.executor = executor;
        this.ownExecutor = ownExecutor;
    }

    public void destroy() {
        List<Runnable> runnables;
        if (this.ownExecutor && !(runnables = ((ThreadPoolExecutor)this.executor).shutdownNow()).isEmpty()) {
            this.logger.warn("Not publishing {} web hook event(s) due to shutdown");
        }
    }

    @Override
    public void publish(WebHookEvent webHookEvent) {
        for (WebHookListener listener : this.listenerProvider.getListeners(webHookEvent)) {
            if (!this.match(webHookEvent, listener) || !Vote.ALLOW.equals((Object)this.accessVoter.canPublish(webHookEvent, listener))) continue;
            this.publish(webHookEvent, listener);
        }
        for (LegacyListener legacyListener : this.legacyListeners.getListeners(webHookEvent.getId())) {
            if (!this.legacyMatch(webHookEvent, legacyListener) || !Vote.ALLOW.equals((Object)this.accessVoter.canPublish(webHookEvent, legacyListener.getListener()))) continue;
            this.publish(webHookEvent, legacyListener.getListener());
        }
    }

    private boolean legacyMatch(WebHookEvent webHookEvent, LegacyListener legacyListener) {
        if (webHookEvent.getEventMatcher() instanceof LegacyEventMatcher) {
            LegacyEventMatcher matcher = (LegacyEventMatcher)webHookEvent.getEventMatcher();
            return matcher.matches(webHookEvent.getEvent(), legacyListener.getLegacyParameters());
        }
        return this.match(webHookEvent, legacyListener.getListener());
    }

    private boolean match(WebHookEvent webHookEvent, WebHookListener listener) {
        return webHookEvent.getEventMatcher().matches(webHookEvent.getEvent(), listener);
    }

    private void publish(WebHookEvent webHookEvent, WebHookListener listener) {
        PublishTask publishTask = this.publishTaskFactory.getPublishTask(webHookEvent, listener);
        try {
            this.executor.execute(publishTask);
            this.eventPublisher.publish((Object)new WebHookPublishedEvent(webHookEvent.getId(), listener.getRegistrationDetails(), listener.getParameters().getUrl()));
        }
        catch (RejectedExecutionException ex) {
            this.logger.warn("Executor rejected the web hook '{}' saying '{}'", (Object)publishTask, (Object)ex.getMessage());
            this.logger.debug("Here is the full exception", (Throwable)ex);
            this.eventPublisher.publish((Object)new WebHookRejectedEvent(webHookEvent.getId(), listener.getRegistrationDetails(), listener.getParameters().getUrl(), ex.getMessage()));
        }
    }
}

