/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.webhooks.api.publish.WebHookEvent;
import com.atlassian.webhooks.plugin.WebHookPublisher;
import com.atlassian.webhooks.plugin.module.WebHookPluginRegistrationContainer;
import com.google.common.base.Preconditions;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public final class WebHookEventsProcessor
implements InitializingBean,
DisposableBean {
    private final EventPublisher eventPublisher;
    private final WebHookPublisher webHookPublisher;
    private final WebHookPluginRegistrationContainer container;
    private final PluginEventManager pluginEventManager;

    public WebHookEventsProcessor(EventPublisher eventPublisher, PluginEventManager pluginEventManager, WebHookPublisher webHookPublisher, WebHookPluginRegistrationContainer container) {
        this.eventPublisher = (EventPublisher)Preconditions.checkNotNull((Object)eventPublisher);
        this.pluginEventManager = (PluginEventManager)Preconditions.checkNotNull((Object)pluginEventManager);
        this.webHookPublisher = (WebHookPublisher)Preconditions.checkNotNull((Object)webHookPublisher);
        this.container = (WebHookPluginRegistrationContainer)Preconditions.checkNotNull((Object)container);
    }

    @EventListener
    public void onEvent(Object event) {
        this.doOnEvent(event);
    }

    private void doOnEvent(Object event) {
        for (WebHookEvent webHookEvent : this.getWebHooksForEvent(event)) {
            this.webHookPublisher.publish(webHookEvent);
        }
    }

    private Iterable<WebHookEvent> getWebHooksForEvent(Object event) {
        return this.container.getWebHookRegistry().getWebHooks(event);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
        this.pluginEventManager.register((Object)this);
    }

    public void destroy() throws Exception {
        this.pluginEventManager.unregister((Object)this);
        this.eventPublisher.unregister((Object)this);
    }
}

