/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.plugin;

class TokenBucket {
    private final long fillAmount;
    private final long fillInterval;
    private final long maxTokens;
    private long currentNumberOfTokens;
    private long lastTokenRemovedTime;

    TokenBucket(long fillAmount, long fillInterval, long maxTokens) {
        this.fillAmount = fillAmount;
        this.fillInterval = fillInterval;
        this.maxTokens = maxTokens;
        this.currentNumberOfTokens = maxTokens;
        this.lastTokenRemovedTime = this.getCurrentMillis();
    }

    public synchronized boolean getToken() {
        boolean isEmpty;
        this.replaceTokens();
        boolean bl = isEmpty = this.currentNumberOfTokens <= 0L;
        if (!isEmpty) {
            --this.currentNumberOfTokens;
            this.lastTokenRemovedTime = this.getCurrentMillis();
        }
        return !isEmpty;
    }

    private void replaceTokens() {
        long currentTime = this.getCurrentMillis();
        long millisecondsSinceLastFill = currentTime - this.lastTokenRemovedTime;
        if (millisecondsSinceLastFill >= this.fillInterval) {
            long numberOfTokensToAdd = millisecondsSinceLastFill / this.fillInterval * this.fillAmount;
            this.currentNumberOfTokens = Math.min(this.maxTokens, this.currentNumberOfTokens + numberOfTokensToAdd);
        }
    }

    long getCurrentMillis() {
        return System.currentTimeMillis();
    }
}

