/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.api.register.listener;

import com.atlassian.annotations.PublicApi;
import com.atlassian.fugue.Option;
import com.atlassian.webhooks.api.util.Filter;
import com.atlassian.webhooks.api.util.SectionKey;
import com.google.common.base.Objects;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@PublicApi
@Immutable
public class PersistentWebHookListener {
    private final Option<Integer> listenerId;
    private final String listenerName;
    private final String description;
    private final Set<String> webHookIds;
    private final String url;
    private final boolean enabled;
    private final boolean excludeBody;
    private final Map<SectionKey, Filter> filters;
    private final Date lastUpdated;
    private final String lastUpdatedByUser;

    private PersistentWebHookListener(Option<Integer> listenerId, String listenerName, String description, Set<String> webHookIds, String url, boolean enabled, boolean excludeBody, Map<SectionKey, Filter> filters, Date lastUpdated, String lastUpdatedByUser) {
        this.listenerId = listenerId;
        this.listenerName = Strings.nullToEmpty((String)listenerName);
        this.description = description;
        this.webHookIds = ImmutableSet.copyOf(webHookIds);
        this.url = Strings.nullToEmpty((String)url);
        this.enabled = enabled;
        this.excludeBody = excludeBody;
        this.filters = ImmutableMap.copyOf(filters);
        this.lastUpdated = (Date)Objects.firstNonNull((Object)lastUpdated, (Object)new Date());
        this.lastUpdatedByUser = Strings.nullToEmpty((String)lastUpdatedByUser);
    }

    public Option<Integer> getId() {
        return this.listenerId;
    }

    public String getName() {
        return this.listenerName;
    }

    public String getDescription() {
        return this.description;
    }

    public Set<String> getEvents() {
        return this.webHookIds;
    }

    public String getUrl() {
        return this.url;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isExcludeBody() {
        return this.excludeBody;
    }

    public Map<SectionKey, Filter> getFilters() {
        return this.filters;
    }

    public Date getLastUpdated() {
        return new Date(this.lastUpdated.getTime());
    }

    public String getLastUpdatedByUser() {
        return this.lastUpdatedByUser;
    }

    public static Builder newlyCreated() {
        return new Builder(null);
    }

    public static Builder existing(Integer id) {
        return new Builder(id);
    }

    public String getFilterFor(@Nullable SectionKey sectionKey) {
        if (sectionKey == null) {
            return "";
        }
        return ((Filter)Objects.firstNonNull((Object)this.filters.get(sectionKey), (Object)new Filter(""))).getValue();
    }

    public static class Builder {
        private final Integer listenerId;
        private String listenerName;
        private String description;
        private final Set<String> webHookIds = Sets.newHashSet();
        private String url;
        private boolean enabled;
        private boolean excludeBody;
        private final Map<SectionKey, Filter> filters = Maps.newHashMap();
        private Date lastUpdated = new Date();
        private String lastUpdatedByUser;

        private Builder(Integer listenerId) {
            this.listenerId = listenerId;
        }

        public Builder setListenerName(String listenerName) {
            this.listenerName = listenerName;
            return this;
        }

        public Builder setDescription(String description) {
            this.description = description;
            return this;
        }

        public Builder addWebHookId(String webhookId) {
            this.webHookIds.add(webhookId);
            return this;
        }

        public Builder addWebHookIds(Collection<String> webHookIds) {
            this.webHookIds.addAll(webHookIds);
            return this;
        }

        public Builder setUrl(String url) {
            this.url = url;
            return this;
        }

        public Builder setEnabled(boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public Builder setExcludeBody(boolean excludeBody) {
            this.excludeBody = excludeBody;
            return this;
        }

        public Builder addFilter(String section, String filter) {
            this.filters.put(new SectionKey(section), new Filter(filter));
            return this;
        }

        public Builder addFilters(Map<String, String> filters) {
            for (Map.Entry<String, String> entry : filters.entrySet()) {
                this.filters.put(new SectionKey(entry.getKey()), new Filter(entry.getValue()));
            }
            return this;
        }

        public Builder addFiltersTypeRich(Map<SectionKey, Filter> filters) {
            this.filters.putAll(filters);
            return this;
        }

        public Builder setLastUpdated(Date lastUpdated) {
            this.lastUpdated = lastUpdated;
            return this;
        }

        public Builder setLastUpdatedByUser(String lastUpdatedByUser) {
            this.lastUpdatedByUser = lastUpdatedByUser;
            return this;
        }

        public PersistentWebHookListener build() {
            return new PersistentWebHookListener(Option.option((Object)this.listenerId), this.listenerName, this.description, this.webHookIds, this.url, this.enabled, this.excludeBody, this.filters, this.lastUpdated, this.lastUpdatedByUser);
        }
    }
}

