/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.api.register;

import com.atlassian.annotations.PublicApi;
import com.atlassian.fugue.Option;
import com.atlassian.webhooks.api.register.RegisteredWebHookEvent;
import com.atlassian.webhooks.api.register.WebHookEventGroup;
import com.atlassian.webhooks.api.register.WebHookEventSection;
import com.atlassian.webhooks.api.register.WebHookPluginRegistration;
import com.atlassian.webhooks.spi.EventSerializer;
import com.atlassian.webhooks.spi.RequestSigner;
import com.atlassian.webhooks.spi.RequestSigner2;
import com.atlassian.webhooks.spi.UriVariablesProvider;
import com.atlassian.webhooks.spi.WebHookListenerActionValidator;
import com.atlassian.webhooks.spi.WebHookPluginRegistrationFactory;
import com.atlassian.webhooks.spi.WebHooksHtmlPanel;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;

@PublicApi
public class WebHookPluginRegistrationBuilder {
    private final Map<Class, UriVariablesProvider> uriVariablesProviders = Maps.newHashMap();
    private final Map<Class, EventSerializer> eventSerializers = Maps.newHashMap();
    private WebHookPluginRegistrationFactory.CloudCondition cloudCondition;
    private final Set<WebHookEventSection> sections = Sets.newLinkedHashSet();
    private final List<WebHooksHtmlPanel> panels = Lists.newArrayList();
    private final Set<RequestSigner> requestSigners = Sets.newHashSet();
    private final Set<RequestSigner2> requestSigners2 = Sets.newHashSet();
    private final Set<WebHookListenerActionValidator> validators = Sets.newLinkedHashSet();
    private final WebHookEventGroup.Builder systemWebHooksGroup = WebHookEventGroup.builder();

    WebHookPluginRegistrationBuilder() {
    }

    public <T> WebHookPluginRegistrationBuilder variablesProvider(Class<T> type, UriVariablesProvider<? super T> uriVariablesProvider) {
        this.uriVariablesProviders.put(type, uriVariablesProvider);
        return this;
    }

    public <T> WebHookPluginRegistrationBuilder eventSerializer(Class<T> type, EventSerializer<? super T> serializer) {
        this.eventSerializers.put(type, serializer);
        return this;
    }

    public WebHookPluginRegistrationBuilder cloudCondition(WebHookPluginRegistrationFactory.CloudCondition cloudCondition) {
        this.cloudCondition = cloudCondition;
        return this;
    }

    public WebHookPluginRegistrationBuilder addWebHookSection(WebHookEventSection section) {
        this.sections.add(section);
        return this;
    }

    public WebHookPluginRegistrationBuilder addWebHook(RegisteredWebHookEvent<?> event) {
        this.systemWebHooksGroup.addEvent(event);
        return this;
    }

    public WebHookPluginRegistrationBuilder addHtmlPanel(WebHooksHtmlPanel panel) {
        this.panels.add(panel);
        return this;
    }

    public WebHookPluginRegistrationBuilder addValidator(WebHookListenerActionValidator actionValidator) {
        this.validators.add(actionValidator);
        return this;
    }

    public WebHookPluginRegistrationBuilder addRequestSigner(RequestSigner requestSigner) {
        this.requestSigners.add(requestSigner);
        return this;
    }

    public WebHookPluginRegistrationBuilder addRequestSigner2(RequestSigner2 requestSigner2) {
        this.requestSigners2.add(requestSigner2);
        return this;
    }

    public WebHookPluginRegistration build() {
        return new WebHookPluginRegistration(this.uriVariablesProviders, this.eventSerializers, (Option<WebHookPluginRegistrationFactory.CloudCondition>)Option.option((Object)this.cloudCondition), Iterables.concat(this.sections, this.systemSection()), this.panels, this.requestSigners, this.requestSigners2, this.validators);
    }

    private Iterable<WebHookEventSection> systemSection() {
        WebHookEventGroup webHooksGroup = this.systemWebHooksGroup.build();
        return webHooksGroup.getEvents().isEmpty() ? Collections.emptySet() : Collections.singleton(WebHookEventSection.section("atlassian-webhooks-plugin-system-webhooks").addGroup(webHooksGroup).build());
    }
}

