/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.api.register;

import com.atlassian.annotations.PublicApi;
import com.atlassian.fugue.Option;
import com.atlassian.webhooks.api.register.RegisteredWebHookEvent;
import com.atlassian.webhooks.api.register.WebHookEventGroup;
import com.atlassian.webhooks.api.register.WebHookEventSection;
import com.atlassian.webhooks.api.register.WebHookPluginRegistrationBuilder;
import com.atlassian.webhooks.spi.EventSerializer;
import com.atlassian.webhooks.spi.RequestSigner;
import com.atlassian.webhooks.spi.RequestSigner2;
import com.atlassian.webhooks.spi.UriVariablesProvider;
import com.atlassian.webhooks.spi.WebHookListenerActionValidator;
import com.atlassian.webhooks.spi.WebHookPluginRegistrationFactory;
import com.atlassian.webhooks.spi.WebHooksHtmlPanel;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.concurrent.Immutable;

@PublicApi
@Immutable
public class WebHookPluginRegistration {
    private final Set<RequestSigner2> requestSigners2;
    private final Map<Class, UriVariablesProvider> uriVariablesProviders;
    private final Map<Class, EventSerializer> eventSerializers;
    private final Option<WebHookPluginRegistrationFactory.CloudCondition> cloudCondition;
    private final List<WebHookEventSection> sections;
    private final List<WebHooksHtmlPanel> panels;
    private final Set<RequestSigner> requestSigners;
    private final Set<WebHookListenerActionValidator> validators;

    public static WebHookPluginRegistrationBuilder builder() {
        return new WebHookPluginRegistrationBuilder();
    }

    WebHookPluginRegistration(Map<Class, UriVariablesProvider> uriVariablesProviders, Map<Class, EventSerializer> serializers, Option<WebHookPluginRegistrationFactory.CloudCondition> cloudCondition, Iterable<WebHookEventSection> sections, List<WebHooksHtmlPanel> panels, Set<RequestSigner> requestSigners, Set<RequestSigner2> requestSigners2, Set<WebHookListenerActionValidator> validators) {
        this.requestSigners2 = requestSigners2;
        this.requestSigners = ImmutableSet.copyOf(requestSigners);
        this.validators = ImmutableSet.copyOf(validators);
        this.sections = ImmutableList.copyOf(sections);
        this.panels = ImmutableList.copyOf(panels);
        this.uriVariablesProviders = ImmutableMap.copyOf(uriVariablesProviders);
        this.cloudCondition = cloudCondition;
        this.eventSerializers = ImmutableMap.copyOf(serializers);
    }

    public Map<Class, UriVariablesProvider> getUriVariablesProviders() {
        return this.uriVariablesProviders;
    }

    public Map<Class, EventSerializer> getEventSerializers() {
        return this.eventSerializers;
    }

    public Option<WebHookPluginRegistrationFactory.CloudCondition> getCloudCondition() {
        return this.cloudCondition;
    }

    public List<WebHookEventSection> getSections() {
        return this.sections;
    }

    private Iterable<WebHookEventGroup> getGroups() {
        return Iterables.concat((Iterable)Iterables.transform(this.sections, (Function)new Function<WebHookEventSection, Set<WebHookEventGroup>>(){

            public Set<WebHookEventGroup> apply(WebHookEventSection section) {
                return section.getGroups();
            }
        }));
    }

    public Iterable<RegisteredWebHookEvent> getRegistrations() {
        return Iterables.concat((Iterable)Iterables.transform(this.getGroups(), (Function)new Function<WebHookEventGroup, Iterable<RegisteredWebHookEvent>>(){

            public Iterable<RegisteredWebHookEvent> apply(WebHookEventGroup group) {
                return group.getEvents();
            }
        }));
    }

    public List<WebHooksHtmlPanel> getPanels() {
        return this.panels;
    }

    public Set<WebHookListenerActionValidator> getValidators() {
        return this.validators;
    }

    public Set<RequestSigner> getRequestSigners() {
        return this.requestSigners;
    }

    public Set<RequestSigner2> getRequestSigners2() {
        return this.requestSigners2;
    }
}

