/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.api.register;

import com.atlassian.annotations.PublicApi;
import com.atlassian.webhooks.api.register.WebHookEventGroup;
import com.atlassian.webhooks.spi.WebHooksHtmlPanel;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@PublicApi
@Immutable
public final class WebHookEventSection {
    private final String key;
    private final String nameI18nKey;
    private final String descriptionI18nKey;
    private final Set<WebHookEventGroup> groups;
    private final List<WebHooksHtmlPanel> panels;

    private WebHookEventSection(String key, String nameI18nKey, String descriptionI18nKey, Set<WebHookEventGroup> groups, List<WebHooksHtmlPanel> panels) {
        this.key = key;
        this.nameI18nKey = nameI18nKey;
        this.descriptionI18nKey = descriptionI18nKey;
        this.groups = ImmutableSet.copyOf(groups);
        this.panels = ImmutableList.copyOf(panels);
    }

    public static Builder section(@Nonnull String key) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)key), (Object)"section key must not be empty");
        return new Builder(key);
    }

    public String getKey() {
        return this.key;
    }

    public String getNameI18nKey() {
        return this.nameI18nKey;
    }

    public String getDescriptionI18nKey() {
        return this.descriptionI18nKey;
    }

    public Set<WebHookEventGroup> getGroups() {
        return this.groups;
    }

    public List<WebHooksHtmlPanel> getPanels() {
        return this.panels;
    }

    @PublicApi
    public static class Builder {
        private final String key;
        private String nameI18nKey = "";
        private String descriptionI18nKey = "";
        private final Set<WebHookEventGroup> groups = Sets.newHashSet();
        private List<WebHooksHtmlPanel> panels = Lists.newArrayList();

        private Builder(String key) {
            this.key = key;
        }

        public Builder nameI18nKey(String nameI18nKey) {
            this.nameI18nKey = nameI18nKey;
            return this;
        }

        public Builder descriptionI18nKey(String descriptionI18nKey) {
            this.descriptionI18nKey = descriptionI18nKey;
            return this;
        }

        public Builder addGroup(WebHookEventGroup group) {
            this.groups.add(group);
            return this;
        }

        public Builder panel(WebHooksHtmlPanel panel) {
            this.panels.add(panel);
            return this;
        }

        public WebHookEventSection build() {
            return new WebHookEventSection(this.key, this.nameI18nKey, this.descriptionI18nKey, this.groups, this.panels);
        }
    }
}

