/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.webhooks.api.register;

import com.atlassian.annotations.PublicApi;
import com.atlassian.webhooks.spi.EventMatcher;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.Immutable;

@PublicApi
@Immutable
public final class RegisteredWebHookEvent<T> {
    private final String id;
    private final String nameI18nKey;
    private final Class<T> eventClass;
    private final EventMatcher<? super T> eventMatcher;

    public static Builder withId(@Nonnull String eventId) {
        Preconditions.checkNotNull((Object)Strings.emptyToNull((String)eventId), (Object)"webhook event id must not be empty");
        return new Builder(eventId);
    }

    private RegisteredWebHookEvent(String id, String nameI18nKey, Class<T> eventClass, EventMatcher<? super T> eventMatcher) {
        this.id = id;
        this.nameI18nKey = nameI18nKey;
        this.eventClass = eventClass;
        this.eventMatcher = eventMatcher;
    }

    public String getId() {
        return this.id;
    }

    public String getNameI18nKey() {
        return this.nameI18nKey;
    }

    public Class<T> getEventClass() {
        return this.eventClass;
    }

    public EventMatcher<? super T> getEventMatcher() {
        return this.eventMatcher;
    }

    @PublicApi
    public static class Builder {
        private final String eventId;

        private Builder(String eventId) {
            this.eventId = eventId;
        }

        public RegisteredWebHookEventBuilder2 andDisplayName(String nameI18nKey) {
            return new RegisteredWebHookEventBuilder2(nameI18nKey);
        }

        public <T> RegisteredWebHookEventBuilder3<T> firedWhen(Class<T> eventClass) {
            return new RegisteredWebHookEventBuilder3("", eventClass);
        }

        public class RegisteredWebHookEventBuilder3<T> {
            private String nameI18nKey;
            private Class<T> eventClass;

            private RegisteredWebHookEventBuilder3(String nameI18nKey, Class<T> eventClass) {
                this.nameI18nKey = nameI18nKey;
                this.eventClass = eventClass;
            }

            public RegisteredWebHookEvent<T> isMatchedBy(EventMatcher<? super T> eventMatches) {
                return new RegisteredWebHookEvent(Builder.this.eventId, this.nameI18nKey, this.eventClass, eventMatches);
            }
        }

        public class RegisteredWebHookEventBuilder2 {
            private String nameI18nKey;

            private RegisteredWebHookEventBuilder2(String nameI18nKey) {
                this.nameI18nKey = nameI18nKey;
            }

            public <T> RegisteredWebHookEventBuilder3<T> firedWhen(Class<T> eventClass) {
                return new RegisteredWebHookEventBuilder3(this.nameI18nKey, eventClass);
            }
        }
    }
}

