/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.gzipfilter.org.tuckey.web.filters.urlrewrite.utils;

import com.atlassian.gzipfilter.org.tuckey.web.filters.urlrewrite.functions.StringFunctions;
import com.atlassian.gzipfilter.org.tuckey.web.filters.urlrewrite.utils.Log;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FunctionReplacer {
    private static Log log = Log.getLog(class$org$tuckey$web$filters$urlrewrite$VariableReplacer == null ? (class$org$tuckey$web$filters$urlrewrite$VariableReplacer = FunctionReplacer.class$("com.atlassian.gzipfilter.org.tuckey.web.filters.urlrewrite.VariableReplacer")) : class$org$tuckey$web$filters$urlrewrite$VariableReplacer);
    private static Pattern functionPattern = Pattern.compile("(?<!\\\\)\\$\\{(.*?)\\}");
    static /* synthetic */ Class class$org$tuckey$web$filters$urlrewrite$VariableReplacer;

    public static boolean containsFunction(String to) {
        Matcher functionMatcher = functionPattern.matcher(to);
        return functionMatcher.find();
    }

    public static String replace(String subjectOfReplacement) {
        Matcher functionMatcher = functionPattern.matcher(subjectOfReplacement);
        StringBuffer sb = new StringBuffer();
        boolean anyMatches = false;
        while (functionMatcher.find()) {
            anyMatches = true;
            int groupCount = functionMatcher.groupCount();
            if (groupCount < 1) {
                log.error("group count on function finder regex is not as expected");
                if (!log.isDebugEnabled()) continue;
                log.error("functionMatcher: " + functionMatcher.toString());
                continue;
            }
            String varStr = functionMatcher.group(1);
            String varValue = "";
            if (varStr != null) {
                varValue = FunctionReplacer.functionReplace(varStr);
                if (log.isDebugEnabled()) {
                    log.debug("resolved to: " + varValue);
                }
            } else if (log.isDebugEnabled()) {
                log.debug("variable reference is null " + functionMatcher);
            }
            functionMatcher.appendReplacement(sb, varValue);
        }
        if (anyMatches) {
            functionMatcher.appendTail(sb);
            log.debug("replaced sb is " + sb);
            return sb.toString();
        }
        return subjectOfReplacement;
    }

    private static String functionReplace(String originalVarStr) {
        String varType;
        String varSubName = null;
        int colonIdx = originalVarStr.indexOf(":");
        if (colonIdx != -1 && colonIdx + 1 < originalVarStr.length()) {
            varSubName = originalVarStr.substring(colonIdx + 1);
            varType = originalVarStr.substring(0, colonIdx);
            if (log.isDebugEnabled()) {
                log.debug("function ${" + originalVarStr + "} type: " + varType + ", name: '" + varSubName + "'");
            }
        } else {
            varType = originalVarStr;
            if (log.isDebugEnabled()) {
                log.debug("function ${" + originalVarStr + "} type: " + varType);
            }
        }
        String functionResult = "";
        if ("replace".equalsIgnoreCase(varType) || "replaceAll".equalsIgnoreCase(varType)) {
            functionResult = StringFunctions.replaceAll(varSubName);
        } else if ("replaceFirst".equalsIgnoreCase(varType)) {
            functionResult = StringFunctions.replaceFirst(varSubName);
        } else if ("escape".equalsIgnoreCase(varType)) {
            functionResult = StringFunctions.escape(varSubName);
        } else if ("unescape".equalsIgnoreCase(varType)) {
            functionResult = StringFunctions.unescape(varSubName);
        } else if ("lower".equalsIgnoreCase(varType) || "toLower".equalsIgnoreCase(varType)) {
            functionResult = StringFunctions.toLower(varSubName);
        } else if ("upper".equalsIgnoreCase(varType) || "toUpper".equalsIgnoreCase(varType)) {
            functionResult = StringFunctions.toUpper(varSubName);
        } else if ("trim".equalsIgnoreCase(varType)) {
            functionResult = StringFunctions.trim(varSubName);
        } else {
            log.error("function ${" + originalVarStr + "} type '" + varType + "' not a valid type");
        }
        return functionResult;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

