/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.db;

import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.config.database.JdbcDatasource;
import com.atlassian.jira.config.database.jdbcurlparser.DatabaseInstance;
import com.atlassian.jira.config.database.jdbcurlparser.JdbcUrlParser;
import com.atlassian.jira.configurator.config.Settings;
import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.configurator.db.DatabaseConfigPanel;
import com.atlassian.jira.configurator.gui.ConfigPanelBuilder;
import com.atlassian.jira.exception.ParseException;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class OracleConfigPanel
extends DatabaseConfigPanel {
    private JTextField tfHostname = new JTextField(20);
    private JTextField tfPort = new JTextField("1521", 20);
    private JTextField tfServiceName = new JTextField(20);
    private JTextField tfUsername = new JTextField(20);
    private JTextField tfPassword = new JPasswordField(20);
    private JPanel configPanel;
    private final JdbcUrlParser urlParser = DatabaseType.ORACLE.getJdbcUrlParser();

    @Override
    public String getDisplayName() {
        return "Oracle";
    }

    @Override
    public String getClassName() {
        return "oracle.jdbc.OracleDriver";
    }

    @Override
    public String getUrl(String jiraHome) {
        try {
            return this.urlParser.getUrl(this.tfHostname.getText(), this.tfPort.getText(), this.tfServiceName.getText());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getUsername() {
        return this.tfUsername.getText();
    }

    @Override
    public String getPassword() {
        return this.tfPassword.getText();
    }

    @Override
    public String getSchemaName() {
        return null;
    }

    @Override
    public JPanel getPanel() {
        if (this.configPanel == null) {
            ConfigPanelBuilder panelBuilder = new ConfigPanelBuilder();
            panelBuilder.add("Hostname", this.tfHostname);
            this.tfHostname.setToolTipText("The hostname or IP address of the Oracle server");
            panelBuilder.add("Port", this.tfPort);
            this.tfPort.setToolTipText("The port number that Oracle is running on. (Default is 1521)");
            panelBuilder.add("Service", this.tfServiceName);
            this.tfServiceName.setToolTipText("Service Name or SID of the Oracle database. (eg 'ORCL'. For Express Edition use 'XE')");
            panelBuilder.add("Username", this.tfUsername);
            this.tfUsername.setToolTipText("The username used to login");
            panelBuilder.add("Password", this.tfPassword);
            this.tfPassword.setToolTipText("The password used to login");
            this.configPanel = panelBuilder.getPanel();
        }
        return this.configPanel;
    }

    @Override
    public void setSettings(Settings settings) throws ParseException {
        JdbcDatasource.Builder datasourceBuilder = settings.getJdbcDatasourceBuilder();
        this.tfUsername.setText(datasourceBuilder.getUsername());
        this.tfPassword.setText(datasourceBuilder.getPassword());
        DatabaseInstance connectionProperties = this.urlParser.parseUrl(datasourceBuilder.getJdbcUrl());
        this.tfHostname.setText(connectionProperties.getHostname());
        this.tfPort.setText(connectionProperties.getPort());
        this.tfServiceName.setText(connectionProperties.getInstance());
    }

    @Override
    public void validate() throws ValidationException {
        if (this.tfPort.getText().trim().length() == 0) {
            throw new ValidationException("Please supply a Port Number to connect to. (Default Oracle port is 1521).");
        }
        this.validatePortNumber(this.tfPort.getText());
    }

    class OracleConnectionProperties {
        String host;
        String port;
        String sid;

        OracleConnectionProperties() {
        }
    }
}

