/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.db;

import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.configurator.config.Settings;
import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.configurator.db.ConfigField;
import com.atlassian.jira.configurator.db.DatabaseConfigConsole;
import com.atlassian.jira.exception.ParseException;

public class H2ConfigConsole
implements DatabaseConfigConsole {
    private final String PREFIX = "jdbc:h2:file:";
    private final String SUFFIX = "/database/h2db";
    private String jiraHome;

    @Override
    public String getDatabaseType() {
        return "H2";
    }

    @Override
    public String getClassName() {
        return DatabaseType.H2.getJdbcDriverClassName();
    }

    @Override
    public String getUsername() {
        return "sa";
    }

    @Override
    public String getPassword() {
        return "";
    }

    @Override
    public ConfigField[] getFields() {
        return null;
    }

    @Override
    public void setSettings(Settings settings) throws ParseException {
        this.jiraHome = settings.getJiraHome();
    }

    @Override
    public String getInstanceName() {
        return "(unused)";
    }

    @Override
    public void saveSettings(Settings newSettings) throws ValidationException {
        newSettings.getJdbcDatasourceBuilder().setDriverClassName(this.getClassName()).setJdbcUrl(this.getUrl()).setUsername(this.getUsername()).setPassword(this.getPassword());
    }

    @Override
    public void testConnection() {
    }

    @Override
    public String getUrl() {
        return "jdbc:h2:file:" + this.jiraHome + "/database/h2db";
    }
}

