/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.db;

import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.config.database.JdbcDatasource;
import com.atlassian.jira.config.database.jdbcurlparser.DatabaseInstance;
import com.atlassian.jira.configurator.config.Settings;
import com.atlassian.jira.configurator.config.ValidationException;
import com.atlassian.jira.configurator.db.DatabaseConfigPanel;
import com.atlassian.jira.exception.ParseException;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public abstract class CommonConfigPanel
extends DatabaseConfigPanel {
    protected JTextField tfHostname = new JTextField(20);
    protected JTextField tfPort = new JTextField(20);
    protected JTextField tfUsername = new JTextField(20);
    protected JTextField tfPassword = new JPasswordField(20);
    private JPanel configPanel;
    private final DatabaseType databaseType;

    public CommonConfigPanel(DatabaseType databaseType) {
        this.tfHostname.setToolTipText("The hostname or IP address of the database server");
        this.tfPort.setToolTipText("The port number that the DB server is listening on");
        this.tfUsername.setToolTipText("The password used to log into the DB server");
        this.tfPassword.setToolTipText("The password used to log into the DB server");
        this.databaseType = databaseType;
    }

    @Override
    public String getUsername() {
        return this.tfUsername.getText();
    }

    @Override
    public String getPassword() {
        return this.tfPassword.getText();
    }

    @Override
    public String getClassName() {
        return this.databaseType.getJdbcDriverClassName();
    }

    @Override
    public String getUrl(String jiraHome) throws ValidationException {
        try {
            return this.databaseType.getJdbcUrlParser().getUrl(this.getHostname(), this.getPort(), this.getInstance());
        }
        catch (ParseException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    protected abstract String getHostname();

    protected abstract String getPort();

    protected abstract String getInstance();

    @Override
    public final JPanel getPanel() {
        if (this.configPanel == null) {
            this.configPanel = this.buildConfigPanel();
        }
        return this.configPanel;
    }

    protected abstract JPanel buildConfigPanel();

    @Override
    public void setSettings(Settings settings) throws ParseException {
        JdbcDatasource.Builder datasourceBuilder = settings.getJdbcDatasourceBuilder();
        this.tfUsername.setText(datasourceBuilder.getUsername());
        this.tfPassword.setText(datasourceBuilder.getPassword());
        this.setUrlSettings(this.databaseType.getJdbcUrlParser(datasourceBuilder.getDriverClassName()).parseUrl(datasourceBuilder.getJdbcUrl()));
        this.setSchemaName(settings.getSchemaName());
    }

    protected abstract void setUrlSettings(DatabaseInstance var1) throws ParseException;

    protected abstract void setSchemaName(String var1);

    @Override
    public void validate() throws ValidationException {
        this.validatePortNumber(this.tfPort.getText());
    }
}

