/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.configurator.config;

import com.atlassian.jira.config.database.DatabaseType;
import com.atlassian.jira.config.database.JdbcDatasource;
import com.atlassian.jira.configurator.config.ComplexConfigurationReason;
import com.atlassian.jira.configurator.config.SslSettings;
import com.atlassian.jira.configurator.config.WebServerProfile;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.ofbiz.core.entity.config.ConnectionPoolInfo;

public class Settings {
    public static final int DEFAULT_POOL_MAX_SIZE = 20;
    public static final long DEFAULT_POOL_MAX_WAIT = 30000L;
    public static final int DEFAULT_REMOVE_ABANDONED_TIMOUT = 300;
    public static final Long HSQL_MIN_EVICTABLE_TIME_MILLIS = 4000L;
    public static final Long HSQL_TIME_BETWEEN_EVICTION_RUNS_MILLIS = 5000L;
    public static final String VALIDATION_QUERY = "select 1";
    public static final String VALIDATION_QUERY_FOR_ORACLE = "select 1 from dual";
    public static final Long MIN_EVICTABLE_TIME_MILLIS = 60000L;
    public static final Long TIME_BETWEEN_EVICTION_RUNS_MILLIS = 300000L;
    public static final int VALIDATION_QUERY_TIMEOUT = 3;
    private String jiraHome;
    private String schemaName;
    private String httpPort = "8080";
    private String controlPort = "8005";
    private SslSettings sslSettings;
    private WebServerProfile webServerProfile = WebServerProfile.HttpOnly;
    private List<ComplexConfigurationReason> complexConfigurationReasons = new ArrayList<ComplexConfigurationReason>();
    private JdbcDatasource.Builder jdbcDatasourceBuilder = JdbcDatasource.builder();
    private ConnectionPoolInfo.Builder connectionPoolInfoBuilder = Settings.newConnectionPoolInfoBuilder();

    public String getJiraHome() {
        return this.jiraHome;
    }

    public void setJiraHome(String jiraHome) {
        this.jiraHome = jiraHome;
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public void setSchemaName(String schemaName) {
        this.schemaName = schemaName;
    }

    public String getHttpPort() {
        return this.httpPort;
    }

    public void setHttpPort(String httpPort) {
        this.httpPort = httpPort;
        this.updateWebServerProfile();
    }

    public String getControlPort() {
        return this.controlPort;
    }

    public void setControlPort(String controlPort) {
        this.controlPort = controlPort;
    }

    @Nullable
    public SslSettings getSslSettings() {
        return this.sslSettings;
    }

    public void setSslSettings(@Nullable SslSettings sslSettings) {
        this.sslSettings = sslSettings;
        this.updateWebServerProfile();
    }

    @Nonnull
    public WebServerProfile getWebServerProfile() {
        return this.webServerProfile;
    }

    public void updateWebServerConfiguration(@Nullable String httpPort, @Nullable SslSettings sslSettings) {
        this.httpPort = httpPort;
        this.sslSettings = sslSettings;
        this.updateWebServerProfile();
    }

    private void updateWebServerProfile() {
        this.webServerProfile = WebServerProfile.retrieveByFlags(this.httpPort != null, this.sslSettings != null);
    }

    @Nonnull
    public List<ComplexConfigurationReason> getComplexConfigurationReasons() {
        return Collections.unmodifiableList(this.complexConfigurationReasons);
    }

    public void addComplexConfigurationReason(@Nonnull ComplexConfigurationReason complexConfigurationReason) {
        this.complexConfigurationReasons.add(complexConfigurationReason);
    }

    public JdbcDatasource.Builder getJdbcDatasourceBuilder() {
        return this.jdbcDatasourceBuilder;
    }

    public void setJdbcDatasourceBuilder(JdbcDatasource.Builder jdbcDatasourceBuilder) {
        this.jdbcDatasourceBuilder = jdbcDatasourceBuilder != null ? jdbcDatasourceBuilder : JdbcDatasource.builder();
    }

    public ConnectionPoolInfo.Builder getConnectionPoolInfoBuilder() {
        return this.connectionPoolInfoBuilder;
    }

    public void setConnectionPoolInfoBuilder(ConnectionPoolInfo.Builder connectionPoolInfoBuilder) {
        if (connectionPoolInfoBuilder != null) {
            if (connectionPoolInfoBuilder.getPoolMaxSize() == null) {
                connectionPoolInfoBuilder.setPoolMaxSize(Integer.valueOf(20));
            }
            this.connectionPoolInfoBuilder = connectionPoolInfoBuilder;
        } else {
            this.connectionPoolInfoBuilder = Settings.newConnectionPoolInfoBuilder();
        }
    }

    public DatabaseType initDatabaseType(boolean initialLoad) {
        DatabaseType newDatabaseType = (DatabaseType)DatabaseType.forJdbcDriverClassName((String)this.jdbcDatasourceBuilder.getDriverClassName()).orElseThrow(new Supplier<IllegalArgumentException>(){

            @Override
            public IllegalArgumentException get() {
                return new IllegalArgumentException(DatabaseType.noMatchingDriverClassNameErrorMessage((String)Settings.this.jdbcDatasourceBuilder.getDriverClassName()));
            }
        });
        this.jdbcDatasourceBuilder.setDatabaseType(newDatabaseType);
        if (initialLoad) {
            this.removeDefaultAdvancedSettings(newDatabaseType);
        }
        return newDatabaseType;
    }

    private void removeDefaultAdvancedSettings(DatabaseType databaseType) {
        Integer removeAbandonedTimeout;
        Boolean removeAbandonedOnMaintenance;
        Boolean removeAbandonedOnBorrow;
        Integer poolMinSize;
        Integer poolMaxIdle;
        Long maxWait;
        Long timeBetweenEvictionRunsMillis;
        Long minEvictableTimeMillis;
        Boolean testWhileIdle;
        switch (databaseType) {
            case MY_SQL: {
                String validationQuery = this.connectionPoolInfoBuilder.getValidationQuery();
                if (validationQuery == null || !validationQuery.trim().equalsIgnoreCase(VALIDATION_QUERY)) break;
                this.connectionPoolInfoBuilder.setValidationQuery(null);
                this.connectionPoolInfoBuilder.setValidationQueryTimeout(null);
                break;
            }
            case POSTGRES: 
            case SQL_SERVER: {
                String validationQuery = this.connectionPoolInfoBuilder.getValidationQuery();
                if (validationQuery == null || !validationQuery.trim().equalsIgnoreCase(VALIDATION_QUERY)) break;
                this.connectionPoolInfoBuilder.setValidationQuery(null);
                break;
            }
            case ORACLE: {
                String validationQuery = this.connectionPoolInfoBuilder.getValidationQuery();
                if (validationQuery == null || !validationQuery.trim().equalsIgnoreCase(VALIDATION_QUERY_FOR_ORACLE)) break;
                this.connectionPoolInfoBuilder.setValidationQuery(null);
                break;
            }
            case HSQL: {
                Long timeBetweenEvictionRunsMillis2;
                Long minEvictableTimeMillis2 = this.connectionPoolInfoBuilder.getMinEvictableTimeMillis();
                if (minEvictableTimeMillis2 != null && minEvictableTimeMillis2.equals(HSQL_MIN_EVICTABLE_TIME_MILLIS)) {
                    this.connectionPoolInfoBuilder.setMinEvictableTimeMillis(null);
                }
                if ((timeBetweenEvictionRunsMillis2 = this.connectionPoolInfoBuilder.getTimeBetweenEvictionRunsMillis()) == null || !timeBetweenEvictionRunsMillis2.equals(HSQL_TIME_BETWEEN_EVICTION_RUNS_MILLIS)) break;
                this.connectionPoolInfoBuilder.setTimeBetweenEvictionRunsMillis(null);
            }
        }
        Integer validationQueryTimeout = this.connectionPoolInfoBuilder.getValidationQueryTimeout();
        if (validationQueryTimeout != null && validationQueryTimeout == 3) {
            this.connectionPoolInfoBuilder.setValidationQueryTimeout(null);
        }
        if ((testWhileIdle = this.connectionPoolInfoBuilder.getTestWhileIdle()) != null && testWhileIdle == Boolean.TRUE) {
            this.connectionPoolInfoBuilder.setTestWhileIdle(null);
        }
        if ((minEvictableTimeMillis = this.connectionPoolInfoBuilder.getMinEvictableTimeMillis()) != null && minEvictableTimeMillis.equals(MIN_EVICTABLE_TIME_MILLIS)) {
            this.connectionPoolInfoBuilder.setMinEvictableTimeMillis(null);
        }
        if ((timeBetweenEvictionRunsMillis = this.connectionPoolInfoBuilder.getTimeBetweenEvictionRunsMillis()) != null && timeBetweenEvictionRunsMillis.equals(TIME_BETWEEN_EVICTION_RUNS_MILLIS)) {
            this.connectionPoolInfoBuilder.setTimeBetweenEvictionRunsMillis(null);
        }
        if (this.connectionPoolInfoBuilder.getPoolMaxSize() == null) {
            this.connectionPoolInfoBuilder.setPoolMaxSize(Integer.valueOf(20));
        }
        if ((maxWait = this.connectionPoolInfoBuilder.getPoolMaxWait()) != null && maxWait.equals(30000L)) {
            this.connectionPoolInfoBuilder.setPoolMaxWait(null);
        }
        if ((poolMaxIdle = this.connectionPoolInfoBuilder.getPoolMaxIdle()) != null && poolMaxIdle.equals(this.connectionPoolInfoBuilder.getPoolMaxSize())) {
            this.connectionPoolInfoBuilder.setPoolMaxIdle(null);
        }
        if ((poolMinSize = this.connectionPoolInfoBuilder.getPoolMinSize()) != null && poolMinSize.equals(this.connectionPoolInfoBuilder.getPoolMaxSize())) {
            this.connectionPoolInfoBuilder.setPoolMinSize(null);
        }
        if (Boolean.TRUE.equals(removeAbandonedOnBorrow = this.connectionPoolInfoBuilder.getRemoveAbandonedOnBorrow())) {
            this.connectionPoolInfoBuilder.setRemoveAbandonedOnBorrow(null);
        }
        if (Boolean.TRUE.equals(removeAbandonedOnMaintenance = this.connectionPoolInfoBuilder.getRemoveAbandonedOnMaintenance())) {
            this.connectionPoolInfoBuilder.setRemoveAbandonedOnMaintenance(null);
        }
        if ((removeAbandonedTimeout = this.connectionPoolInfoBuilder.getRemoveAbandonedTimeout()) != null && removeAbandonedTimeout.equals(300)) {
            this.connectionPoolInfoBuilder.setRemoveAbandonedTimeout(null);
        }
    }

    public void applyDefaultAdvancedSettings() {
        switch (this.initDatabaseType(false)) {
            case MY_SQL: {
                if (this.connectionPoolInfoBuilder.getValidationQuery() == null) {
                    this.connectionPoolInfoBuilder.setValidationQuery(VALIDATION_QUERY);
                }
                if (this.connectionPoolInfoBuilder.getValidationQueryTimeout() != null) break;
                this.connectionPoolInfoBuilder.setValidationQueryTimeout(Integer.valueOf(3));
                break;
            }
            case POSTGRES: 
            case SQL_SERVER: {
                if (this.connectionPoolInfoBuilder.getValidationQuery() != null) break;
                this.connectionPoolInfoBuilder.setValidationQuery(VALIDATION_QUERY);
                break;
            }
            case ORACLE: {
                if (this.connectionPoolInfoBuilder.getValidationQuery() != null) break;
                this.connectionPoolInfoBuilder.setValidationQuery(VALIDATION_QUERY_FOR_ORACLE);
                break;
            }
            case HSQL: {
                if (this.connectionPoolInfoBuilder.getMinEvictableTimeMillis() == null) {
                    this.connectionPoolInfoBuilder.setMinEvictableTimeMillis(HSQL_MIN_EVICTABLE_TIME_MILLIS);
                }
                if (this.connectionPoolInfoBuilder.getTimeBetweenEvictionRunsMillis() != null) break;
                this.connectionPoolInfoBuilder.setTimeBetweenEvictionRunsMillis(HSQL_TIME_BETWEEN_EVICTION_RUNS_MILLIS);
            }
        }
        if (this.connectionPoolInfoBuilder.getTestWhileIdle() == null) {
            this.connectionPoolInfoBuilder.setTestWhileIdle(Boolean.valueOf(true));
        }
        if (this.connectionPoolInfoBuilder.getTestOnBorrow() == null) {
            this.connectionPoolInfoBuilder.setTestOnBorrow(Boolean.valueOf(false));
        }
        if (this.connectionPoolInfoBuilder.getMinEvictableTimeMillis() == null) {
            this.connectionPoolInfoBuilder.setMinEvictableTimeMillis(MIN_EVICTABLE_TIME_MILLIS);
        }
        if (this.connectionPoolInfoBuilder.getTimeBetweenEvictionRunsMillis() == null) {
            this.connectionPoolInfoBuilder.setTimeBetweenEvictionRunsMillis(TIME_BETWEEN_EVICTION_RUNS_MILLIS);
        }
        if (this.connectionPoolInfoBuilder.getPoolMaxSize() == null) {
            this.connectionPoolInfoBuilder.setPoolMaxSize(Integer.valueOf(20));
        }
        if (this.connectionPoolInfoBuilder.getPoolMaxWait() == null) {
            this.connectionPoolInfoBuilder.setPoolMaxWait(Long.valueOf(30000L));
        }
        if (this.connectionPoolInfoBuilder.getPoolMaxIdle() == null) {
            this.connectionPoolInfoBuilder.setPoolMaxIdle(this.connectionPoolInfoBuilder.getPoolMaxSize());
        }
        if (this.connectionPoolInfoBuilder.getPoolMinSize() == null) {
            this.connectionPoolInfoBuilder.setPoolMinSize(this.connectionPoolInfoBuilder.getPoolMaxSize());
        }
        if (this.connectionPoolInfoBuilder.getRemoveAbandonedOnBorrow() == null) {
            this.connectionPoolInfoBuilder.setRemoveAbandonedOnBorrow(Boolean.valueOf(true));
        }
        if (this.connectionPoolInfoBuilder.getRemoveAbandonedTimeout() == null) {
            this.connectionPoolInfoBuilder.setRemoveAbandonedTimeout(Integer.valueOf(300));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Settings settings = (Settings)o;
        return Settings.equals(this.controlPort, settings.controlPort) && Settings.equals(this.httpPort, settings.httpPort) && Settings.equals(this.jiraHome, settings.jiraHome) && Settings.equals(this.schemaName, settings.schemaName) && Settings.equals(this.jdbcDatasourceBuilder, settings.jdbcDatasourceBuilder) && Settings.equals(this.connectionPoolInfoBuilder, settings.connectionPoolInfoBuilder) && Settings.equals(this.sslSettings, settings.sslSettings);
    }

    private static <T> boolean equals(T o1, T o2) {
        return o1 != null ? o1.equals(o2) : o2 == null;
    }

    private static ConnectionPoolInfo.Builder newConnectionPoolInfoBuilder() {
        return ConnectionPoolInfo.builder().setPoolMaxSize(Integer.valueOf(20));
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }
}

