/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.memcached;

import com.atlassian.vcache.CasIdentifier;
import com.atlassian.vcache.ExternalCacheException;
import com.atlassian.vcache.IdentifiedValue;
import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.internal.core.DefaultIdentifiedValue;
import com.atlassian.vcache.internal.core.VCacheCoreUtils;
import com.atlassian.vcache.internal.memcached.MemcachedCasIdentifier;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.spy.memcached.CASValue;
import net.spy.memcached.MemcachedClientIF;
import net.spy.memcached.OperationTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MemcachedUtils {
    private static final Logger log = LoggerFactory.getLogger(MemcachedUtils.class);
    private static final int MAX_SECONDS_OFFSET = 2592000;

    MemcachedUtils() {
    }

    static long safeExtractId(CasIdentifier casId) {
        if (casId instanceof MemcachedCasIdentifier) {
            return ((MemcachedCasIdentifier)casId).getId();
        }
        log.warn("Passed an unknown CasIdentifier instance of class {}.", (Object)casId.getClass().getName());
        throw new ExternalCacheException(ExternalCacheException.Reason.UNCLASSIFIED_FAILURE);
    }

    @Nonnull
    static <V> Optional<IdentifiedValue<V>> identifiedValueFrom(Future<CASValue<Object>> op, Marshaller<V> valueMarshaller) {
        CASValue<Object> casValue;
        try {
            casValue = op.get();
        }
        catch (InterruptedException | ExecutionException ex) {
            throw new ExternalCacheException(ExternalCacheException.Reason.UNCLASSIFIED_FAILURE, (Throwable)ex);
        }
        if (casValue == null) {
            return Optional.empty();
        }
        MemcachedCasIdentifier identifier = new MemcachedCasIdentifier(casValue.getCas());
        DefaultIdentifiedValue iv = new DefaultIdentifiedValue((CasIdentifier)identifier, VCacheCoreUtils.unmarshall((byte[])((byte[])casValue.getValue()), valueMarshaller).get());
        return Optional.of(iv);
    }

    @Nonnull
    static Future<Boolean> putOperationForPolicy(PutPolicy policy, MemcachedClientIF client, String externalKey, int defaultTtl, byte[] valueBytes) {
        Future putOp;
        if (policy == PutPolicy.ADD_ONLY) {
            putOp = client.add(externalKey, defaultTtl, (Object)valueBytes);
        } else if (policy == PutPolicy.PUT_ALWAYS) {
            putOp = client.set(externalKey, defaultTtl, (Object)valueBytes);
        } else if (policy == PutPolicy.REPLACE_ONLY) {
            putOp = client.replace(externalKey, defaultTtl, (Object)valueBytes);
        } else {
            throw new IllegalArgumentException("Unknown put policy: " + policy);
        }
        return putOp;
    }

    @Nonnull
    static ExternalCacheException mapException(Exception ex) {
        if (ex instanceof OperationTimeoutException) {
            return new ExternalCacheException(ExternalCacheException.Reason.TIMEOUT, (Throwable)ex);
        }
        return new ExternalCacheException(ExternalCacheException.Reason.UNCLASSIFIED_FAILURE, (Throwable)ex);
    }

    @Nonnull
    static <V> Map<String, Optional<V>> directGetBulk(Set<String> externalKeys, Supplier<MemcachedClientIF> clientSupplier, Marshaller<V> valueMarshaller) {
        Map haveValues = clientSupplier.get().getBulk(externalKeys);
        return externalKeys.stream().collect(Collectors.toMap(k -> k, k -> VCacheCoreUtils.unmarshall((byte[])((byte[])haveValues.get(k)), (Marshaller)valueMarshaller)));
    }

    static long obtainCacheVersion(Supplier<MemcachedClientIF> clientSupplier, String externalCacheVersionKey) {
        return clientSupplier.get().incr(externalCacheVersionKey, 0, 1L);
    }

    static long incrementCacheVersion(Supplier<MemcachedClientIF> clientSupplier, String externalCacheVersionKey) {
        return clientSupplier.get().incr(externalCacheVersionKey, 1, 1L);
    }

    static int expiryTime(int seconds) {
        if (seconds < 2592000) {
            return seconds;
        }
        int currentTime = (int)(System.currentTimeMillis() / 1000L);
        return currentTime + seconds;
    }
}

