/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.memcached;

import com.atlassian.vcache.ExternalCacheException;
import com.atlassian.vcache.ExternalCacheSettings;
import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.MarshallerException;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.TransactionControl;
import com.atlassian.vcache.internal.core.TransactionControlManager;
import com.atlassian.vcache.internal.core.VCacheCoreUtils;
import com.atlassian.vcache.internal.core.service.AbstractExternalCacheRequestContext;
import com.atlassian.vcache.internal.core.service.AbstractTransactionalExternalCache;
import com.atlassian.vcache.internal.core.service.VersionedExternalCacheRequestContext;
import com.atlassian.vcache.internal.memcached.MemcachedUtils;
import java.time.Duration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.spy.memcached.MemcachedClientIF;
import net.spy.memcached.OperationTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MemcachedTransactionalExternalCache<V>
extends AbstractTransactionalExternalCache<V> {
    private static final Logger log = LoggerFactory.getLogger(MemcachedTransactionalExternalCache.class);
    private final Supplier<MemcachedClientIF> clientSupplier;
    private final ExternalCacheKeyGenerator keyGenerator;
    private final Marshaller<V> valueMarshaller;
    private final int ttlSeconds;
    private final TransactionControlManager transactionControlManager;

    MemcachedTransactionalExternalCache(Supplier<MemcachedClientIF> clientSupplier, Supplier<RequestContext> contextSupplier, ExternalCacheKeyGenerator keyGenerator, String name, Marshaller<V> valueMarshaller, ExternalCacheSettings settings, TransactionControlManager transactionControlManager) {
        super(name, contextSupplier);
        this.clientSupplier = Objects.requireNonNull(clientSupplier);
        this.keyGenerator = Objects.requireNonNull(keyGenerator);
        this.valueMarshaller = Objects.requireNonNull(valueMarshaller);
        this.ttlSeconds = VCacheCoreUtils.roundUpToSeconds((Duration)((Duration)settings.getDefaultTtl().get()));
        this.transactionControlManager = Objects.requireNonNull(transactionControlManager);
    }

    public void transactionSync() {
        log.trace("Cache {}: synchronising operations", (Object)this.name);
        VersionedExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
        if (cacheContext.hasRemoveAll()) {
            cacheContext.updateCacheVersion(MemcachedUtils.incrementCacheVersion(this.clientSupplier, cacheContext.externalCacheVersionKey()));
        }
        this.performKeyedOperations(cacheContext);
        cacheContext.forgetAll();
    }

    private void performKeyedOperations(VersionedExternalCacheRequestContext<V> cacheContext) {
        HashMap futureToFailureMessageMap = new HashMap();
        cacheContext.getKeyedOperations().forEach(entry -> {
            String externalKey = cacheContext.externalEntryKeyFor((String)entry.getKey());
            if (((AbstractExternalCacheRequestContext.DeferredOperation)entry.getValue()).isRemove()) {
                log.trace("Cache {}: performing remove on entry {}", (Object)this.name, entry.getKey());
                futureToFailureMessageMap.put(this.clientSupplier.get().delete(externalKey), "remove entry " + (String)entry.getKey());
            } else {
                log.trace("Cache {}: performing {} on entry {}", new Object[]{this.name, ((AbstractExternalCacheRequestContext.DeferredOperation)entry.getValue()).getPolicy(), entry.getKey()});
                try {
                    byte[] valueBytes = this.valueMarshaller.marshall(((AbstractExternalCacheRequestContext.DeferredOperation)entry.getValue()).getValue());
                    Future<Boolean> putOp = MemcachedUtils.putOperationForPolicy(((AbstractExternalCacheRequestContext.DeferredOperation)entry.getValue()).getPolicy(), this.clientSupplier.get(), externalKey, MemcachedUtils.expiryTime(this.ttlSeconds), valueBytes);
                    futureToFailureMessageMap.put(putOp, "put using policy " + ((AbstractExternalCacheRequestContext.DeferredOperation)entry.getValue()).getPolicy() + " on entry " + (String)entry.getKey());
                }
                catch (MarshallerException mex) {
                    log.warn("Cache {}: Unable to marshall value to perform put operation on entry {}", new Object[]{this.name, entry.getKey(), mex});
                }
            }
        });
        boolean[] anOperationFailed = new boolean[1];
        futureToFailureMessageMap.entrySet().forEach(entry -> {
            try {
                Boolean outcome = (Boolean)((Future)entry.getKey()).get();
                if (outcome.booleanValue()) {
                    log.trace("Cache {}: successful deferred operation for {}", (Object)this.name, entry.getValue());
                } else {
                    anOperationFailed[0] = true;
                    log.warn("Cache {}: failed deferred operation for {}", (Object)this.name, entry.getValue());
                }
            }
            catch (InterruptedException | ExecutionException ex) {
                anOperationFailed[0] = true;
                log.error("Cache {}: had failure getting result for deferred operation {}", new Object[]{this.name, entry.getValue(), ex});
            }
        });
        if (anOperationFailed[0]) {
            log.error("Cache {}: an operation failed in transaction sync, so clearing the cache", (Object)this.name);
            cacheContext.updateCacheVersion(MemcachedUtils.incrementCacheVersion(this.clientSupplier, cacheContext.externalCacheVersionKey()));
        }
    }

    @Nonnull
    protected VersionedExternalCacheRequestContext<V> ensureCacheContext() throws OperationTimeoutException {
        RequestContext requestContext = (RequestContext)this.contextSupplier.get();
        return (VersionedExternalCacheRequestContext)requestContext.computeIfAbsent((Object)this, () -> {
            this.transactionControlManager.registerTransactionalExternalCache(requestContext, this.name, (TransactionControl)this);
            log.trace("Cache {}: Setting up a new context", (Object)this.name);
            VersionedExternalCacheRequestContext newCacheContext = new VersionedExternalCacheRequestContext(this.keyGenerator, this.name, () -> ((RequestContext)requestContext).partitionIdentifier());
            newCacheContext.updateCacheVersion(MemcachedUtils.obtainCacheVersion(this.clientSupplier, newCacheContext.externalCacheVersionKey()));
            return newCacheContext;
        });
    }

    @Nonnull
    protected Logger getLogger() {
        return log;
    }

    @Nonnull
    protected final ExternalCacheException mapException(Exception ex) {
        return MemcachedUtils.mapException(ex);
    }

    @Nonnull
    protected final Optional<V> directGet(String externalKey) {
        return VCacheCoreUtils.unmarshall((byte[])((byte[])this.clientSupplier.get().get(externalKey)), this.valueMarshaller);
    }

    @Nonnull
    protected final Map<String, Optional<V>> directGetBulk(Set<String> externalKeys) {
        return MemcachedUtils.directGetBulk(externalKeys, this.clientSupplier, this.valueMarshaller);
    }
}

