/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.memcached;

import com.atlassian.vcache.ExternalCacheException;
import com.atlassian.vcache.ExternalCacheSettings;
import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.MarshallerException;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.VCacheCoreUtils;
import com.atlassian.vcache.internal.core.service.AbstractStableReadExternalCache;
import com.atlassian.vcache.internal.core.service.VersionedExternalCacheRequestContext;
import com.atlassian.vcache.internal.memcached.MemcachedUtils;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import net.spy.memcached.MemcachedClientIF;
import net.spy.memcached.OperationTimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class MemcachedStableReadExternalCache<V>
extends AbstractStableReadExternalCache<V> {
    private static final Logger log = LoggerFactory.getLogger(MemcachedStableReadExternalCache.class);
    private final Supplier<MemcachedClientIF> clientSupplier;
    private final Supplier<RequestContext> contextSupplier;
    private final ExternalCacheKeyGenerator keyGenerator;
    private final Marshaller<V> valueMarshaller;
    private final int ttlSeconds;

    MemcachedStableReadExternalCache(Supplier<MemcachedClientIF> clientSupplier, Supplier<RequestContext> contextSupplier, ExternalCacheKeyGenerator keyGenerator, String name, Marshaller<V> valueMarshaller, ExternalCacheSettings settings) {
        super(name);
        this.clientSupplier = Objects.requireNonNull(clientSupplier);
        this.contextSupplier = Objects.requireNonNull(contextSupplier);
        this.keyGenerator = Objects.requireNonNull(keyGenerator);
        this.valueMarshaller = Objects.requireNonNull(valueMarshaller);
        this.ttlSeconds = VCacheCoreUtils.roundUpToSeconds((Duration)((Duration)settings.getDefaultTtl().get()));
    }

    @Nonnull
    public CompletionStage<Boolean> put(String internalKey, V value, PutPolicy policy) {
        VersionedExternalCacheRequestContext cacheContext = this.ensureCacheContext();
        return this.perform(() -> {
            String externalKey = cacheContext.externalEntryKeyFor(internalKey);
            byte[] valueBytes = this.valueMarshaller.marshall(value);
            Future<Boolean> putOp = MemcachedUtils.putOperationForPolicy(policy, this.clientSupplier.get(), externalKey, MemcachedUtils.expiryTime(this.ttlSeconds), valueBytes);
            return putOp.get();
        }, result -> {
            if (result.booleanValue()) {
                cacheContext.recordValue(internalKey, Optional.of(value));
            } else {
                cacheContext.forgetValue(internalKey);
            }
        });
    }

    @Nonnull
    public CompletionStage<Void> remove(Iterable<String> internalKeys) {
        return this.perform(() -> {
            if (VCacheCoreUtils.isEmpty((Iterable)internalKeys)) {
                return null;
            }
            VersionedExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
            Map<String, Future> deleteOps = StreamSupport.stream(internalKeys.spliterator(), false).distinct().collect(Collectors.toMap(k -> k, k -> this.clientSupplier.get().delete(cacheContext.externalEntryKeyFor(k))));
            Exception failureException = null;
            for (Map.Entry<String, Future> delOp : deleteOps.entrySet()) {
                try {
                    delOp.getValue().get();
                    cacheContext.recordValue(delOp.getKey(), Optional.empty());
                }
                catch (InterruptedException | ExecutionException ex) {
                    log.info("Cache {}: unable to remove key {}", new Object[]{this.name, delOp.getKey(), ex});
                    failureException = ex;
                }
            }
            if (failureException != null) {
                if (failureException instanceof ExecutionException) {
                    throw (ExecutionException)failureException;
                }
                throw (InterruptedException)failureException;
            }
            return null;
        });
    }

    @Nonnull
    public CompletionStage<Void> removeAll() {
        return this.perform(() -> {
            VersionedExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
            cacheContext.updateCacheVersion(MemcachedUtils.incrementCacheVersion(this.clientSupplier, cacheContext.externalCacheVersionKey()));
            cacheContext.forgetAllValues();
            return null;
        });
    }

    @Nonnull
    protected Logger getLogger() {
        return log;
    }

    @Nonnull
    protected VersionedExternalCacheRequestContext<V> ensureCacheContext() throws OperationTimeoutException {
        RequestContext requestContext = this.contextSupplier.get();
        return (VersionedExternalCacheRequestContext)requestContext.computeIfAbsent((Object)this, () -> {
            log.trace("Cache {}: Setting up a new context", (Object)this.name);
            VersionedExternalCacheRequestContext newCacheContext = new VersionedExternalCacheRequestContext(this.keyGenerator, this.name, () -> ((RequestContext)requestContext).partitionIdentifier());
            newCacheContext.updateCacheVersion(MemcachedUtils.obtainCacheVersion(this.clientSupplier, newCacheContext.externalCacheVersionKey()));
            return newCacheContext;
        });
    }

    @Nonnull
    protected V handleCreation(String internalKey, Supplier<V> supplier) throws MarshallerException, ExecutionException, InterruptedException {
        Future addOp;
        VersionedExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
        V candidateValue = Objects.requireNonNull(supplier.get());
        byte[] candidateValueBytes = this.valueMarshaller.marshall(candidateValue);
        String externalKey = cacheContext.externalEntryKeyFor(internalKey);
        while (!((Boolean)(addOp = this.clientSupplier.get().add(externalKey, MemcachedUtils.expiryTime(this.ttlSeconds), (Object)candidateValueBytes)).get()).booleanValue()) {
            this.getLogger().info("Cache {}, unable to add candidate for key {}, retrieve what was added", (Object)this.name, (Object)internalKey);
            Optional otherAddedValue = VCacheCoreUtils.unmarshall((byte[])((byte[])this.clientSupplier.get().get(externalKey)), this.valueMarshaller);
            if (otherAddedValue.isPresent()) {
                cacheContext.recordValue(internalKey, otherAddedValue);
                return (V)otherAddedValue.get();
            }
            this.getLogger().info("Cache {}, unable to retrieve recently added candidate for key {}, looping", (Object)this.name, (Object)internalKey);
        }
        cacheContext.recordValue(internalKey, Optional.of(candidateValue));
        return candidateValue;
    }

    @Nonnull
    protected Map<String, V> handleCreation(Function<Set<String>, Map<String, V>> factory, Set<String> externalKeys) throws ExecutionException, InterruptedException {
        VersionedExternalCacheRequestContext cacheContext = this.ensureCacheContext();
        Map haveValues = this.clientSupplier.get().getBulk(externalKeys);
        this.getLogger().trace("Cache {}: getBulk(Function): {} of {} entries have values", new Object[]{this.name, haveValues.size(), externalKeys.size()});
        HashSet<String> missingExternalKeys = new HashSet<String>(externalKeys);
        missingExternalKeys.removeAll(haveValues.keySet());
        Map<String, Object> grandResult = haveValues.entrySet().stream().collect(Collectors.toMap(e -> cacheContext.internalEntryKeyFor((String)e.getKey()), e -> VCacheCoreUtils.unmarshall((byte[])((byte[])e.getValue()), this.valueMarshaller).get()));
        if (!missingExternalKeys.isEmpty()) {
            this.getLogger().trace("Cache {}: getBulk(Function): calling factory to create {} values", (Object)this.name, (Object)missingExternalKeys.size());
            Set missingInternalKeys = Collections.unmodifiableSet(missingExternalKeys.stream().map(arg_0 -> cacheContext.internalEntryKeyFor(arg_0)).collect(Collectors.toSet()));
            Map<String, V> missingValues = factory.apply(missingInternalKeys);
            if (missingInternalKeys.size() != missingValues.size()) {
                this.getLogger().warn("Cache {}: getBulk(Function): mismatch on generated values, expected ", (Object)this.name, (Object)(missingInternalKeys.size() + " but got " + missingValues.size()));
                throw new ExternalCacheException(ExternalCacheException.Reason.FUNCTION_INCORRECT_RESULT);
            }
            Map<String, Future> internalKeyToFutureMap = missingValues.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> this.clientSupplier.get().set(cacheContext.externalEntryKeyFor((String)e.getKey()), MemcachedUtils.expiryTime(this.ttlSeconds), (Object)VCacheCoreUtils.marshall(e.getValue(), this.valueMarshaller))));
            for (Map.Entry<String, Future> e2 : internalKeyToFutureMap.entrySet()) {
                e2.getValue().get();
            }
            grandResult.putAll(missingValues);
        }
        return grandResult;
    }

    @Nonnull
    protected final ExternalCacheException mapException(Exception ex) {
        return MemcachedUtils.mapException(ex);
    }

    @Nonnull
    protected final Optional<V> directGet(String externalKey) {
        return VCacheCoreUtils.unmarshall((byte[])((byte[])this.clientSupplier.get().get(externalKey)), this.valueMarshaller);
    }

    @Nonnull
    protected final Map<String, Optional<V>> directGetBulk(Set<String> externalKeys) {
        return MemcachedUtils.directGetBulk(externalKeys, this.clientSupplier, this.valueMarshaller);
    }
}

