/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.analytics.statistics.projects;

import com.atlassian.jira.analytics.statistics.StatisticsEventProducer;
import com.atlassian.jira.analytics.statistics.projects.ProjectsStatisticEvent;
import com.atlassian.jira.analytics.statistics.projects.ProjectsStatisticEventBuilder;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeKeys;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProjectsStatistics
implements StatisticsEventProducer<ProjectsStatisticEvent> {
    private final ProjectManager projectManager;

    @Autowired
    public ProjectsStatistics(@ComponentImport ProjectManager projectManager) {
        this.projectManager = projectManager;
    }

    @Override
    public ProjectsStatisticEvent getEvent() {
        Map<ProjectTypeKey, Long> projectCounts = this.projectManager.getProjects().stream().map(Project::getProjectTypeKey).collect(Collectors.groupingBy(e -> e, Collectors.counting()));
        return new ProjectsStatisticEventBuilder().setSoftware(projectCounts.getOrDefault(ProjectTypeKeys.SOFTWARE, 0L)).setBusiness(projectCounts.getOrDefault(ProjectTypeKeys.BUSINESS, 0L)).setServicedesk(projectCounts.getOrDefault(ProjectTypeKeys.SERVICE_DESK, 0L)).setTotal(projectCounts.values().stream().mapToLong(e -> e).sum()).createProjectsStatisticEvent();
    }
}

