/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.analytics.statistics.priorities;

import com.atlassian.jira.JiraFeatureFlagRegistrar;
import com.atlassian.jira.analytics.statistics.StatisticsEventProducer;
import com.atlassian.jira.analytics.statistics.priorities.PrioritiesStatisticEvent;
import com.atlassian.jira.analytics.statistics.priorities.PrioritiesStatisticEventBuilder;
import com.atlassian.jira.config.ConstantsManager;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.jira.issue.fields.config.manager.PrioritySchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeKeys;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PrioritiesStatistics
implements StatisticsEventProducer<PrioritiesStatisticEvent> {
    private static final Logger log = LoggerFactory.getLogger(PrioritiesStatistics.class);
    private final ConstantsManager constantsManager;
    private final FeatureManager featureManager;
    private final PrioritySchemeManager prioritySchemesManager;
    private final ProjectManager projectManager;

    @Autowired
    public PrioritiesStatistics(@ComponentImport ConstantsManager constantsManager, @ComponentImport FeatureManager featureManager, @ComponentImport PrioritySchemeManager prioritySchemesManager, @ComponentImport ProjectManager projectManager) {
        this.constantsManager = constantsManager;
        this.featureManager = featureManager;
        this.prioritySchemesManager = prioritySchemesManager;
        this.projectManager = projectManager;
    }

    @Override
    public PrioritiesStatisticEvent getEvent() {
        log.trace("Counting priorities statistics");
        long prioritiesTotal = this.constantsManager.getPriorities().size();
        boolean pppEnabled = this.featureManager.isEnabled(JiraFeatureFlagRegistrar.PRIORITIES_PER_PROJECT);
        PrioritiesStatisticEventBuilder eventBuilder = new PrioritiesStatisticEventBuilder().setPppEnabled(pppEnabled).setPrioritiesTotal(prioritiesTotal);
        this.populateSchemesData(eventBuilder, pppEnabled);
        this.populateProjectsData(eventBuilder);
        log.trace("Priorities statistics calculated");
        return eventBuilder.createPrioritiesStatisticEvent();
    }

    private void populateProjectsData(PrioritiesStatisticEventBuilder eventBuilder) {
        List projects = this.projectManager.getProjects();
        List projectsWithoutDefaultScheme = projects.stream().filter(s -> !this.prioritySchemesManager.isDefaultScheme(this.prioritySchemesManager.getScheme(s))).collect(Collectors.toList());
        Map<ProjectTypeKey, List<Project>> projectsByType = projectsWithoutDefaultScheme.stream().collect(Collectors.groupingBy(Project::getProjectTypeKey));
        long schemesAssigned = projectsByType.values().stream().flatMap(Collection::stream).map(arg_0 -> ((PrioritySchemeManager)this.prioritySchemesManager).getScheme(arg_0)).distinct().count();
        eventBuilder.setBusinessProjectsWithScheme(projectsByType.getOrDefault(ProjectTypeKeys.BUSINESS, (List<Project>)ImmutableList.of()).size()).setSoftwareProjectsWithScheme(projectsByType.getOrDefault(ProjectTypeKeys.SOFTWARE, (List<Project>)ImmutableList.of()).size()).setServicedeskProjectsWithScheme(projectsByType.getOrDefault(ProjectTypeKeys.SERVICE_DESK, (List<Project>)ImmutableList.of()).size()).setProjectsTotal(projects.size()).setProjectsWithDefaultScheme(projects.size() - projectsWithoutDefaultScheme.size()).setSchemesAssigned(schemesAssigned);
    }

    private void populateSchemesData(PrioritiesStatisticEventBuilder result, boolean includeSchemeStatistics) {
        List prioritySchemes = this.prioritySchemesManager.getAllSchemes().stream().filter(s -> !this.prioritySchemesManager.isDefaultScheme(s)).collect(Collectors.toList());
        Map<Integer, Long> priorityOccurenceInScheme = prioritySchemes.stream().map(arg_0 -> ((PrioritySchemeManager)this.prioritySchemesManager).getFieldConfigForDefaultMapping(arg_0)).map(arg_0 -> ((PrioritySchemeManager)this.prioritySchemesManager).getOptions(arg_0)).map(List::size).collect(Collectors.groupingBy(prioritiesInScheme -> prioritiesInScheme, Collectors.counting()));
        result.setSchemesTotal(prioritySchemes.size());
        if (includeSchemeStatistics) {
            boolean isEmpty = priorityOccurenceInScheme.isEmpty();
            long minPrioritiesInScheme = isEmpty ? 0L : (long)Collections.min(priorityOccurenceInScheme.keySet()).intValue();
            long maxPrioritiesInScheme = isEmpty ? 0L : (long)Collections.max(priorityOccurenceInScheme.keySet()).intValue();
            long mostPopularPrioritiesCountInScheme = isEmpty ? 0L : (long)((Integer)Collections.max(priorityOccurenceInScheme.entrySet(), Map.Entry.comparingByValue()).getKey()).intValue();
            result.setMinPrioritiesInScheme(minPrioritiesInScheme).setMaxPrioritiesInScheme(maxPrioritiesInScheme).setMostPopularPrioritiesCountInScheme(mostPopularPrioritiesCountInScheme);
        } else {
            result.setMinPrioritiesInScheme(0L).setMaxPrioritiesInScheme(0L).setMostPopularPrioritiesCountInScheme(0L);
        }
    }
}

