/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.analytics.statistics.customfields;

import com.atlassian.jira.analytics.statistics.StatisticsEventProducer;
import com.atlassian.jira.analytics.statistics.customfields.CustomFieldsStatisticEvent;
import com.atlassian.jira.analytics.statistics.customfields.CustomFieldsStatisticEventBuilder;
import com.atlassian.jira.issue.CustomFieldManager;
import com.atlassian.jira.issue.fields.ConfigurableField;
import com.atlassian.jira.issue.fields.CustomField;
import com.atlassian.jira.issue.fields.config.manager.FieldConfigSchemeManager;
import com.atlassian.jira.project.Project;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.project.type.ProjectTypeKey;
import com.atlassian.jira.project.type.ProjectTypeKeys;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CustomFieldsStatistics
implements StatisticsEventProducer<CustomFieldsStatisticEvent> {
    private final ProjectManager projectManager;
    private final CustomFieldManager customFieldManager;
    private final FieldConfigSchemeManager fieldConfigSchemeManager;

    @Autowired
    public CustomFieldsStatistics(@ComponentImport ProjectManager projectManager, @ComponentImport CustomFieldManager customFieldManager, @ComponentImport FieldConfigSchemeManager fieldConfigSchemeManager) {
        this.projectManager = projectManager;
        this.customFieldManager = customFieldManager;
        this.fieldConfigSchemeManager = fieldConfigSchemeManager;
    }

    @Override
    public CustomFieldsStatisticEvent getEvent() {
        List customfields = this.customFieldManager.getCustomFieldObjects();
        List nonManagedCustomfields = customfields.stream().filter(cf -> !cf.getCustomFieldType().getDescriptor().isTypeManaged()).collect(Collectors.toList());
        Map<CustomField, ProjectCount> customfieldToProjectCount = nonManagedCustomfields.stream().collect(Collectors.toMap(cf -> cf, cf -> this.getProjectCount((CustomField)cf)));
        List allProjects = this.projectManager.getProjects();
        Map<ProjectTypeKey, Long> projectCounts = allProjects.stream().map(Project::getProjectTypeKey).collect(Collectors.groupingBy(e -> e, Collectors.counting()));
        return new CustomFieldsStatisticEventBuilder().setProjectCount(allProjects.size()).setBusinessProjectCount(projectCounts.getOrDefault(ProjectTypeKeys.BUSINESS, 0L)).setSwProjectCount(projectCounts.getOrDefault(ProjectTypeKeys.SOFTWARE, 0L)).setSdProjectCount(projectCounts.getOrDefault(ProjectTypeKeys.SERVICE_DESK, 0L)).setCfCount(customfields.size()).setNmCfCount(nonManagedCustomfields.size()).setNmCfInProjectCount(customfieldToProjectCount.values().stream().mapToLong(pc -> pc.all).sum()).setNmCfInBusinessProjectCount(customfieldToProjectCount.values().stream().mapToLong(pc -> pc.business).sum()).setNmCfInSwProjectCount(customfieldToProjectCount.values().stream().mapToLong(pc -> pc.software).sum()).setNmCfInSdProjectCount(customfieldToProjectCount.values().stream().mapToLong(pc -> pc.serviceDesk).sum()).setNmCfInAtLeastOneProjectCount(customfieldToProjectCount.values().stream().filter(pc -> pc.all > 0L).count()).createCustomFieldsStatisticEvent();
    }

    public ProjectCount getProjectCount(CustomField customField) {
        Map<ProjectTypeKey, Long> projectTypeToCountForCustomfield = this.fieldConfigSchemeManager.getConfigSchemesForField((ConfigurableField)customField).stream().flatMap(fcs -> fcs.getAssociatedProjectObjects().stream()).distinct().collect(Collectors.groupingBy(p -> p.getProjectTypeKey(), Collectors.counting()));
        return new ProjectCount(projectTypeToCountForCustomfield.getOrDefault(ProjectTypeKeys.BUSINESS, 0L), projectTypeToCountForCustomfield.getOrDefault(ProjectTypeKeys.SOFTWARE, 0L), projectTypeToCountForCustomfield.getOrDefault(ProjectTypeKeys.SERVICE_DESK, 0L), projectTypeToCountForCustomfield.values().stream().mapToLong(l -> l).sum());
    }

    class ProjectCount {
        long business;
        long software;
        long serviceDesk;
        long all;

        public ProjectCount(long business, long software, long serviceDesk, long all) {
            this.business = business;
            this.software = software;
            this.serviceDesk = serviceDesk;
            this.all = all;
        }
    }
}

