/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.analytics.statistics;

import com.atlassian.jira.analytics.event.WorkflowsStatisticEvent;
import com.atlassian.jira.analytics.statistics.StatisticsEventProducer;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.jira.workflow.WorkflowManager;
import com.atlassian.jira.workflow.WorkflowSchemeManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkflowStatistics
implements StatisticsEventProducer<WorkflowsStatisticEvent> {
    private static final Logger log = LoggerFactory.getLogger(WorkflowStatistics.class);
    private final ProjectManager projectManager;
    private final WorkflowSchemeManager workflowSchemeManager;
    private final WorkflowManager workflowManager;

    @Autowired
    public WorkflowStatistics(@ComponentImport ProjectManager projectManager, @ComponentImport WorkflowSchemeManager workflowSchemeManager, @ComponentImport WorkflowManager workflowManager) {
        this.projectManager = projectManager;
        this.workflowSchemeManager = workflowSchemeManager;
        this.workflowManager = workflowManager;
    }

    private static Map<String, String> ADD_DEFAULT_WORKFLOW_IF_MISSING(Map<String, String> workflowMap) {
        HashMap<String, String> newMap = new HashMap<String, String>(workflowMap);
        String defaultWorkflow = (String)newMap.get(null);
        if (Objects.isNull(defaultWorkflow)) {
            newMap.put(null, "jira");
        }
        return newMap;
    }

    @Override
    public WorkflowsStatisticEvent getEvent() {
        log.trace("Counting workflow statistics");
        Map<String, Long> workflowProjectOccurrence = this.projectManager.getProjects().stream().map(p -> {
            Map<String, String> workflowMap = WorkflowStatistics.ADD_DEFAULT_WORKFLOW_IF_MISSING(this.workflowSchemeManager.getWorkflowMap(p));
            String defaultWorkflowName = workflowMap.get(null);
            return p.getIssueTypes().stream().map(it -> (String)workflowMap.get(it.getId())).map(wf -> Objects.isNull(wf) ? defaultWorkflowName : wf).distinct().collect(Collectors.toList());
        }).flatMap(Collection::stream).collect(Collectors.groupingBy(wf -> wf, Collectors.counting()));
        long usedWorkflowsCount = workflowProjectOccurrence.size();
        long isolatedWorkflowsCount = workflowProjectOccurrence.entrySet().stream().filter(entry -> (Long)entry.getValue() == 1L).count();
        long sharedWorkflowsCount = usedWorkflowsCount - isolatedWorkflowsCount;
        long inactiveWorkflowsCount = this.workflowManager.getWorkflows().size() - this.workflowManager.getActiveWorkflows().size();
        long totalWorkflowsCount = inactiveWorkflowsCount + usedWorkflowsCount;
        log.trace("Workflows statistics calculated");
        return new WorkflowsStatisticEvent(totalWorkflowsCount, isolatedWorkflowsCount, sharedWorkflowsCount, inactiveWorkflowsCount);
    }
}

