/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.analytics.statistics;

import com.atlassian.jira.analytics.event.PermissionsStatisticEvent;
import com.atlassian.jira.analytics.statistics.StatisticsEventProducer;
import com.atlassian.jira.permission.PermissionSchemeAttributeManager;
import com.atlassian.jira.permission.PermissionSchemeManager;
import com.atlassian.jira.project.ProjectManager;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PermissionSchemeStatistics
implements StatisticsEventProducer<PermissionsStatisticEvent> {
    private static final Logger log = LoggerFactory.getLogger(PermissionSchemeStatistics.class);
    private final PermissionSchemeManager permissionSchemeManager;
    private final ProjectManager projectManager;
    private final PermissionSchemeAttributeManager permissionSchemeAttributeManager;

    @Autowired
    public PermissionSchemeStatistics(@ComponentImport PermissionSchemeManager permissionSchemeManager, @ComponentImport ProjectManager projectManager, @ComponentImport PermissionSchemeAttributeManager permissionSchemeAttributeManager) {
        this.permissionSchemeManager = permissionSchemeManager;
        this.projectManager = projectManager;
        this.permissionSchemeAttributeManager = permissionSchemeAttributeManager;
    }

    @Override
    public PermissionsStatisticEvent getEvent() {
        log.trace("Counting permission statistics");
        List allSchemes = this.permissionSchemeManager.getSchemeObjects();
        Long allProjects = this.projectManager.getProjectCount();
        List collect = allSchemes.stream().filter(scheme -> this.permissionSchemeAttributeManager.getAttribute(scheme.getId(), "ADMINISTER_PROJECTS.extended.enabled").map(Boolean::valueOf).orElse(false)).map(arg_0 -> ((PermissionSchemeManager)this.permissionSchemeManager).getProjects(arg_0)).map(List::size).collect(Collectors.toList());
        long schemesWithExtendedAdminEnabled = collect.size();
        Integer projectsWithExtendedAdmin = collect.stream().reduce(0, Integer::sum);
        log.trace("Permissions statistics calculated");
        return new PermissionsStatisticEvent(allSchemes.size(), schemesWithExtendedAdminEnabled, allProjects, projectsWithExtendedAdmin.intValue());
    }
}

