/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.analytics.scheduler;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.analytics.scheduler.AnalyticsJob;
import com.atlassian.jira.analytics.statistics.StatisticsEventProducer;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.Schedule;
import java.util.Collection;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
public class AnalyticsScheduler
implements LifecycleAware {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticsScheduler.class);
    private static final String JOB_KEY_STRING = AnalyticsScheduler.class.getName();
    private static final JobId JOB_ID = JobId.of((String)JOB_KEY_STRING);
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)JOB_KEY_STRING);
    private static final String OLD_JOB_KEY_STRING = "com.atlassian.jira.projectconfig.analytics.AnalyticsScheduler";
    private static final JobId OLD_JOB_ID = JobId.of((String)"com.atlassian.jira.projectconfig.analytics.AnalyticsScheduler");
    private static final JobRunnerKey OLD_JOB_RUNNER_KEY = JobRunnerKey.of((String)"com.atlassian.jira.projectconfig.analytics.AnalyticsScheduler");
    private static final long SCHEDULER_START_DELAY = 86400000L;
    private static final long SCHEDULER_INTERVAL = 604800000L;
    private final SchedulerService schedulerService;
    private final Collection<StatisticsEventProducer> eventProducers;
    private final EventPublisher eventPublisher;

    @Autowired
    public AnalyticsScheduler(@ComponentImport SchedulerService schedulerService, Collection<StatisticsEventProducer> eventProducers, @ComponentImport EventPublisher eventPublisher) {
        this.schedulerService = schedulerService;
        this.eventProducers = eventProducers;
        this.eventPublisher = eventPublisher;
    }

    private JobConfig getJobConfig(JobRunnerKey jobRunnerKey) {
        return JobConfig.forJobRunnerKey((JobRunnerKey)jobRunnerKey).withSchedule(Schedule.forInterval((long)604800000L, (Date)new Date(System.currentTimeMillis() + 86400000L)));
    }

    private void unschedule(JobId jobId, JobRunnerKey jobRunnerKey) {
        this.schedulerService.unscheduleJob(jobId);
        this.schedulerService.unregisterJobRunner(jobRunnerKey);
        LOG.trace("Unregistering and unscheduling AnalyticsJob with key: ", (Object)jobId.toString());
    }

    public void onStart() {
        LOG.trace("Registering and scheduling AnalyticsJob");
        this.unschedule(OLD_JOB_ID, OLD_JOB_RUNNER_KEY);
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new AnalyticsJob(this.eventProducers, this.eventPublisher));
        try {
            this.schedulerService.scheduleJob(JOB_ID, this.getJobConfig(JOB_RUNNER_KEY));
            LOG.trace("AnalyticsJob schedule successfully completed");
        }
        catch (SchedulerServiceException e) {
            LOG.error("Error was thrown during scheduling an AnalyticsJob", (Throwable)e);
        }
    }

    public void onStop() {
        this.unschedule(JOB_ID, JOB_RUNNER_KEY);
    }
}

