/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.analytics.scheduler;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.analytics.statistics.StatisticsEventProducer;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import java.util.Collection;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyticsJob
implements JobRunner {
    private static final Logger LOG = LoggerFactory.getLogger(AnalyticsJob.class);
    private final Collection<StatisticsEventProducer> eventProducers;
    private final EventPublisher eventPublisher;

    public AnalyticsJob(Collection<StatisticsEventProducer> eventProducers, @ComponentImport EventPublisher eventPublisher) {
        this.eventProducers = eventProducers;
        this.eventPublisher = eventPublisher;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest request) {
        this.eventProducers.forEach(this::sendEventSafely);
        return JobRunnerResponse.success();
    }

    private void sendEventSafely(StatisticsEventProducer<?> statisticsEventProducer) {
        try {
            this.eventPublisher.publish(statisticsEventProducer.getEvent());
        }
        catch (RuntimeException e) {
            LOG.info("Unsuccessful statistic calculation", (Throwable)e);
        }
    }
}

