/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.guava;

import com.atlassian.vcache.DirectExternalCache;
import com.atlassian.vcache.ExternalCacheSettings;
import com.atlassian.vcache.JvmCache;
import com.atlassian.vcache.JvmCacheSettings;
import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.StableReadExternalCache;
import com.atlassian.vcache.TransactionalExternalCache;
import com.atlassian.vcache.internal.BegunTransactionalActivityHandler;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.VCacheCreationHandler;
import com.atlassian.vcache.internal.VCacheSettingsDefaultsProvider;
import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.Sha1ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.metrics.MetricsCollector;
import com.atlassian.vcache.internal.core.service.AbstractVCacheService;
import com.atlassian.vcache.internal.core.service.GuavaJvmCache;
import com.atlassian.vcache.internal.guava.GuavaDirectExternalCache;
import com.atlassian.vcache.internal.guava.GuavaServiceSettings;
import com.atlassian.vcache.internal.guava.GuavaStableReadExternalCache;
import com.atlassian.vcache.internal.guava.GuavaTransactionalExternalCache;
import com.atlassian.vcache.internal.guava.GuavaUtils;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaVCacheService
extends AbstractVCacheService {
    private static final Logger log = LoggerFactory.getLogger(GuavaVCacheService.class);
    private final GuavaServiceSettings serviceSettings;

    public GuavaVCacheService(String productIdentifier, Supplier<RequestContext> contextSupplier, VCacheSettingsDefaultsProvider defaultsProvider, VCacheCreationHandler creationHandler, MetricsCollector metricsCollector, GuavaServiceSettings serviceSettings, BegunTransactionalActivityHandler begunTransactionalActivityHandler) {
        super(contextSupplier, defaultsProvider, creationHandler, metricsCollector, (ExternalCacheKeyGenerator)new Sha1ExternalCacheKeyGenerator(productIdentifier), begunTransactionalActivityHandler);
        this.serviceSettings = Objects.requireNonNull(serviceSettings);
    }

    public GuavaVCacheService(Supplier<RequestContext> contextSupplier, VCacheSettingsDefaultsProvider defaultsProvider, VCacheCreationHandler creationHandler, MetricsCollector metricsCollector, ExternalCacheKeyGenerator externalCacheKeyGenerator, GuavaServiceSettings serviceSettings, BegunTransactionalActivityHandler begunTransactionalActivityHandler) {
        super(contextSupplier, defaultsProvider, creationHandler, metricsCollector, externalCacheKeyGenerator, begunTransactionalActivityHandler);
        this.serviceSettings = Objects.requireNonNull(serviceSettings);
    }

    @Nonnull
    protected Logger log() {
        return log;
    }

    @Nonnull
    protected <K, V> JvmCache<K, V> createJvmCache(String name, JvmCacheSettings settings) {
        return new GuavaJvmCache(name, settings);
    }

    @Nonnull
    protected <V> TransactionalExternalCache<V> createTransactionalExternalCache(String name, ExternalCacheSettings settings, Marshaller<V> valueMarshaller, boolean valueSerializable) {
        return new GuavaTransactionalExternalCache<V>(name, GuavaUtils.buildDelegate(settings), this.contextSupplier, this.externalCacheKeyGenerator, this.serviceSettings.isSerializationHack() && valueSerializable ? Optional.empty() : Optional.of(valueMarshaller), this.transactionControlManager);
    }

    @Nonnull
    protected <V> StableReadExternalCache<V> createStableReadExternalCache(String name, ExternalCacheSettings settings, Marshaller<V> valueMarshaller, boolean valueSerializable) {
        return new GuavaStableReadExternalCache<V>(name, GuavaUtils.buildDelegate(settings), this.contextSupplier, this.externalCacheKeyGenerator, this.serviceSettings.isSerializationHack() && valueSerializable ? Optional.empty() : Optional.of(valueMarshaller));
    }

    @Nonnull
    protected <V> DirectExternalCache<V> createDirectExternalCache(String name, ExternalCacheSettings settings, Marshaller<V> valueMarshaller, boolean valueSerializable) {
        return new GuavaDirectExternalCache<V>(name, GuavaUtils.buildDelegate(settings), this.contextSupplier, this.externalCacheKeyGenerator, this.serviceSettings.isSerializationHack() && valueSerializable ? Optional.empty() : Optional.of(valueMarshaller));
    }
}

