/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.guava;

import com.atlassian.vcache.ExternalCacheException;
import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.internal.RequestContext;
import com.atlassian.vcache.internal.core.ExternalCacheKeyGenerator;
import com.atlassian.vcache.internal.core.TransactionControl;
import com.atlassian.vcache.internal.core.TransactionControlManager;
import com.atlassian.vcache.internal.core.cas.IdentifiedData;
import com.atlassian.vcache.internal.core.cas.IdentifiedUtils;
import com.atlassian.vcache.internal.core.service.AbstractExternalCacheRequestContext;
import com.atlassian.vcache.internal.core.service.AbstractTransactionalExternalCache;
import com.atlassian.vcache.internal.core.service.UnversionedExternalCacheRequestContext;
import com.atlassian.vcache.internal.guava.GuavaUtils;
import com.google.common.cache.Cache;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuavaTransactionalExternalCache<V>
extends AbstractTransactionalExternalCache<V> {
    private static final Logger log = LoggerFactory.getLogger(GuavaTransactionalExternalCache.class);
    private final Cache<String, IdentifiedData> delegate;
    private final ExternalCacheKeyGenerator keyGenerator;
    private final Optional<Marshaller<V>> valueMarshaller;
    private final TransactionControlManager transactionControlManager;

    public GuavaTransactionalExternalCache(String name, Cache<String, IdentifiedData> delegate, Supplier<RequestContext> contextSupplier, ExternalCacheKeyGenerator keyGenerator, Optional<Marshaller<V>> valueMarshaller, TransactionControlManager transactionControlManager) {
        super(name, contextSupplier);
        this.delegate = Objects.requireNonNull(delegate);
        this.keyGenerator = Objects.requireNonNull(keyGenerator);
        this.valueMarshaller = Objects.requireNonNull(valueMarshaller);
        this.transactionControlManager = Objects.requireNonNull(transactionControlManager);
    }

    public void transactionSync() {
        log.trace("Cache {}: synchronising operations", (Object)this.name);
        AbstractExternalCacheRequestContext<V> cacheContext = this.ensureCacheContext();
        if (cacheContext.hasRemoveAll()) {
            this.delegate.asMap().clear();
        }
        this.performKeyedOperations(cacheContext);
        cacheContext.forgetAll();
    }

    private void performKeyedOperations(AbstractExternalCacheRequestContext<V> cacheContext) {
        try {
            cacheContext.getKeyedOperations().forEach(entry -> {
                String externalKey = cacheContext.externalEntryKeyFor((String)entry.getKey());
                if (((AbstractExternalCacheRequestContext.DeferredOperation)entry.getValue()).isRemove()) {
                    log.trace("Cache {}: performing remove on entry {}", (Object)this.name, entry.getKey());
                    this.delegate.asMap().remove(externalKey);
                } else {
                    log.trace("Cache {}: performing {} on entry {}", new Object[]{this.name, ((AbstractExternalCacheRequestContext.DeferredOperation)entry.getValue()).getPolicy(), entry.getKey()});
                    IdentifiedData identifiedData = IdentifiedUtils.marshall((Object)((AbstractExternalCacheRequestContext.DeferredOperation)entry.getValue()).getValue(), this.valueMarshaller);
                    boolean putOutcome = GuavaUtils.directPut(externalKey, identifiedData, ((AbstractExternalCacheRequestContext.DeferredOperation)entry.getValue()).getPolicy(), this.delegate);
                    if (!putOutcome) {
                        log.warn("Cache {}: Unable to marshall value to perform put operation on entry {}", (Object)this.name, entry.getKey());
                        throw new ExternalCacheException(ExternalCacheException.Reason.TRANSACTION_FAILURE);
                    }
                }
            });
        }
        catch (ExternalCacheException bugger) {
            log.error("Cache {}: an operation failed in transaction sync, so clearing the cache", (Object)this.name);
            this.delegate.asMap().clear();
        }
    }

    @Nonnull
    protected AbstractExternalCacheRequestContext<V> ensureCacheContext() {
        RequestContext requestContext = (RequestContext)this.contextSupplier.get();
        return (AbstractExternalCacheRequestContext)requestContext.computeIfAbsent((Object)this, () -> {
            this.transactionControlManager.registerTransactionalExternalCache(requestContext, this.name, (TransactionControl)this);
            log.trace("Cache {}: Setting up a new context", (Object)this.name);
            return new UnversionedExternalCacheRequestContext(this.keyGenerator, this.getName(), () -> ((RequestContext)requestContext).partitionIdentifier());
        });
    }

    @Nonnull
    protected Logger getLogger() {
        return log;
    }

    @Nonnull
    protected final ExternalCacheException mapException(Exception ex) {
        return GuavaUtils.mapException(ex);
    }

    @Nonnull
    protected final Optional<V> directGet(String externalKey) {
        return IdentifiedUtils.unmarshall((IdentifiedData)((IdentifiedData)this.delegate.getIfPresent((Object)externalKey)), this.valueMarshaller);
    }

    @Nonnull
    protected final Map<String, Optional<V>> directGetBulk(Set<String> externalKeys) {
        return GuavaUtils.directGetBulk(externalKeys, this.delegate, this.valueMarshaller);
    }
}

