/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.jotm;

import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.rmi.PortableRemoteObject;
import javax.transaction.xa.Xid;
import org.objectweb.jotm.Control;
import org.objectweb.jotm.ControlImpl;
import org.objectweb.jotm.Coordinator;
import org.objectweb.jotm.TraceTm;
import org.objectweb.jotm.TransactionContext;
import org.objectweb.jotm.TransactionFactory;
import org.objectweb.jotm.XidImpl;

public class TransactionFactoryImpl
extends PortableRemoteObject
implements TransactionFactory {
    int timeoutMax = 3600;
    private Vector coordinatorList = new Vector();

    public TransactionFactoryImpl() throws RemoteException {
        TraceTm.jotm.debug((Object)"default constructor");
    }

    public synchronized Control create(int timeout) throws RemoteException {
        TraceTm.jotm.debug((Object)("timeout=" + timeout));
        ControlImpl ctrl = null;
        if (timeout == 0 || timeout > this.timeoutMax) {
            timeout = this.timeoutMax;
        }
        XidImpl xid = new XidImpl("TMServer", 0);
        try {
            ctrl = new ControlImpl(timeout, xid, null);
        }
        catch (Exception e) {
            TraceTm.jotm.error((Object)"Cannot create ControlImpl", (Throwable)e);
        }
        return ctrl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Control recreate(TransactionContext ctx) throws RemoteException {
        TraceTm.jotm.debug((Object)("TransactionContext=" + ctx));
        ControlImpl ctrl = null;
        Vector vector = this.coordinatorList;
        synchronized (vector) {
            int i = 0;
            while (i < this.coordinatorList.size()) {
                Coordinator coord = (Coordinator)this.coordinatorList.elementAt(i);
                if (coord.equals(ctx.getCoordinator())) {
                    TraceTm.jotm.debug((Object)"recreate: Control already in the list");
                    ctrl = (ControlImpl)coord;
                    break;
                }
                ++i;
            }
        }
        if (ctrl != null) {
            TraceTm.jotm.debug((Object)"recreate twice");
            return ctrl;
        }
        Xid xid = ctx.getXid();
        try {
            ctrl = new ControlImpl(ctx.getTimeout(), xid, ctx.getCoordinator());
        }
        catch (Exception e) {
            TraceTm.jotm.error((Object)"Cannot create ControlImpl", (Throwable)e);
        }
        return ctrl;
    }

    public int getPortNumber() throws RemoteException {
        return 0;
    }

    public String getHostName() throws RemoteException {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (Exception e) {
            throw new RemoteException("" + e);
        }
    }
}

