/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.bsf;

import com.ibm.bsf.BSFException;
import com.ibm.bsf.BSFManager;
import com.ibm.bsf.util.CodeBuffer;
import com.ibm.bsf.util.IOUtils;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.util.Hashtable;

public class Main {
    private static String ARG_IN = "-in";
    private static String ARG_LANG = "-lang";
    private static String ARG_MODE = "-mode";
    private static String ARG_OUT = "-out";
    private static String ARG_VAL_EVAL = "eval";
    private static String ARG_VAL_EXEC = "exec";
    private static String ARG_VAL_COMPILE = "compile";
    private static String DEFAULT_IN_FILE_NAME = "<STDIN>";
    private static String DEFAULT_MODE = ARG_VAL_EVAL;
    private static String DEFAULT_CLASS_NAME = "Test";
    static /* synthetic */ Class class$com$ibm$bsf$Main;

    private static void printHelp() {
        System.err.println("Usage:");
        System.err.println();
        System.err.println("  java " + (class$com$ibm$bsf$Main == null ? (class$com$ibm$bsf$Main = Main.class$("com.ibm.bsf.Main")) : class$com$ibm$bsf$Main).getName() + " [args]");
        System.err.println();
        System.err.println("    args:");
        System.err.println();
        System.err.println("      [-in                fileName]   default: " + DEFAULT_IN_FILE_NAME);
        System.err.println("      [-lang          languageName]   default: <If -in is specified and -lang");
        System.err.println("                                                is not, attempt to determine");
        System.err.println("                                                language from file extension;");
        System.err.println("                                                otherwise, -lang is required.>");
        System.err.println("      [-mode   (eval|exec|compile)]   default: " + DEFAULT_MODE);
        System.err.println();
        System.err.println("    Additional args used only if -mode is set to \"compile\":");
        System.err.println();
        System.err.println("      [-out              className]   default: " + DEFAULT_CLASS_NAME);
    }

    public static void main(String[] stringArray) throws IOException {
        try {
            InputStreamReader inputStreamReader;
            if (stringArray.length == 0 || stringArray.length % 2 != 0) {
                Main.printHelp();
                System.exit(1);
            }
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put(ARG_OUT, DEFAULT_CLASS_NAME);
            hashtable.put(ARG_MODE, DEFAULT_MODE);
            int n = 0;
            while (n < stringArray.length) {
                hashtable.put(stringArray[n], stringArray[n + 1]);
                n += 2;
            }
            String string = (String)hashtable.get(ARG_IN);
            String string2 = (String)hashtable.get(ARG_LANG);
            if (string2 == null) {
                if (string != null) {
                    string2 = BSFManager.getLangFromFilename(string);
                } else {
                    throw new BSFException(BSFException.REASON_OTHER_ERROR, "unable to determine language");
                }
            }
            if (string != null) {
                inputStreamReader = new FileReader(string);
            } else {
                inputStreamReader = new InputStreamReader(System.in);
                string = "<STDIN>";
            }
            BSFManager bSFManager = new BSFManager();
            String string3 = (String)hashtable.get(ARG_MODE);
            if (string3.equals(ARG_VAL_COMPILE)) {
                String string4 = (String)hashtable.get(ARG_OUT);
                FileWriter fileWriter = new FileWriter(string4 + ".java");
                PrintWriter printWriter = new PrintWriter(fileWriter);
                CodeBuffer codeBuffer = new CodeBuffer();
                codeBuffer.setClassName(string4);
                bSFManager.compileScript(string2, string, 0, 0, IOUtils.getStringFromReader(inputStreamReader), codeBuffer);
                codeBuffer.print(printWriter, true);
                fileWriter.close();
            } else if (string3.equals(ARG_VAL_EXEC)) {
                bSFManager.exec(string2, string, 0, 0, IOUtils.getStringFromReader(inputStreamReader));
            } else {
                Object object = bSFManager.eval(string2, string, 0, 0, IOUtils.getStringFromReader(inputStreamReader));
                if (object instanceof Component) {
                    Frame frame;
                    if (object instanceof Frame) {
                        frame = (Frame)object;
                    } else {
                        frame = new Frame("BSF Result: " + string);
                        frame.add((Component)object);
                    }
                    frame.addWindowListener(new WindowAdapter(){

                        public void windowClosing(WindowEvent windowEvent) {
                            System.exit(0);
                        }
                    });
                    frame.pack();
                    frame.show();
                } else {
                    System.err.println("Result: " + object);
                }
            }
        }
        catch (BSFException bSFException) {
            bSFException.printStackTrace();
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

