/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.ozymandias;

import com.atlassian.fugue.Option;
import com.atlassian.ozymandias.PluginPointFunction;
import com.atlassian.ozymandias.PluginPointVisitor;
import com.atlassian.ozymandias.SafeAccess;
import com.atlassian.ozymandias.SafeAccessViaPluginAccessor;
import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SafePluginPointAccess
implements SafeAccessViaPluginAccessor,
SafeAccess {
    private final PluginAccessor pluginAccessor;

    private SafePluginPointAccess() {
        this.pluginAccessor = null;
    }

    private SafePluginPointAccess(PluginAccessor pluginAccessor) {
        this.pluginAccessor = pluginAccessor;
    }

    public static SafeAccessViaPluginAccessor to(PluginAccessor pluginAccessor) {
        return new SafePluginPointAccess(pluginAccessor);
    }

    public static SafeAccess to() {
        return new SafePluginPointAccess();
    }

    @Override
    public <MT, RT, D extends ModuleDescriptor<MT>> List<RT> forType(Class<D> moduleDescriptorClass, PluginPointFunction<D, MT, RT> callback) {
        List<D> moduleDescriptors = this.getModuleDescriptors(moduleDescriptorClass);
        return this.descriptors(moduleDescriptors, callback);
    }

    @Override
    public <MT, D extends ModuleDescriptor<MT>> void forType(Class<D> moduleDescriptorClass, PluginPointVisitor<D, MT> visitor) {
        List<D> moduleDescriptors = this.getModuleDescriptors(moduleDescriptorClass);
        this.descriptors(moduleDescriptors, visitor);
    }

    @Override
    public <MT, RT, D extends ModuleDescriptor<MT>> List<RT> descriptors(Iterable<D> moduleDescriptors, PluginPointFunction<D, MT, RT> callback) {
        AccumulatingVisitor visitor = new AccumulatingVisitor(callback);
        this.descriptors(moduleDescriptors, visitor);
        return visitor.getResults();
    }

    @Override
    public <MT, RT, D extends ModuleDescriptor<MT>> List<RT> modules(Iterable<MT> modules, PluginPointFunction<D, MT, RT> callback) {
        AccumulatingVisitor visitor = new AccumulatingVisitor(callback);
        this.modules(modules, visitor);
        return visitor.getResults();
    }

    @Override
    public <MT, RT, D extends ModuleDescriptor<MT>> RT module(MT module, PluginPointFunction<D, MT, RT> callback) {
        List<RT> result = this.modules(this.singleList(module), callback);
        return result.isEmpty() ? null : (RT)result.get(0);
    }

    @Override
    public <MT, D extends ModuleDescriptor<MT>> void descriptors(Iterable<D> moduleDescriptors, PluginPointVisitor<D, MT> visitor) {
        for (ModuleDescriptor moduleDescriptor : moduleDescriptors) {
            if (moduleDescriptor == null) continue;
            Object module = null;
            try {
                module = moduleDescriptor.getModule();
            }
            catch (Throwable t) {
                SafePluginPointAccess.handleException(t, moduleDescriptor);
                continue;
            }
            this.invokeModule(visitor, moduleDescriptor, module);
        }
    }

    @Override
    public <MT, D extends ModuleDescriptor<MT>> void module(MT module, PluginPointVisitor<D, MT> visitor) {
        this.modules(this.singleList(module), visitor);
    }

    @Override
    public <MT, D extends ModuleDescriptor<MT>> void modules(Iterable<MT> modules, PluginPointVisitor<D, MT> visitor) {
        for (MT module : modules) {
            if (module == null) continue;
            this.invokeModule(visitor, null, module);
        }
    }

    @Override
    @Deprecated
    @Nullable
    public <RT> RT callable(Callable<RT> callable) {
        return (RT)SafePluginPointAccess.call(callable).getOrNull();
    }

    public static <RT> Option<RT> call(Callable<RT> callable) {
        try {
            return Option.option(callable.call());
        }
        catch (Throwable t) {
            SafePluginPointAccess.handleException(t);
            return Option.none();
        }
    }

    @Override
    public void runnable(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (Throwable t) {
            SafePluginPointAccess.handleException(t);
        }
    }

    public static <T> Predicate<T> safe(final Predicate<T> base) {
        return new Predicate<T>(){

            public boolean apply(@Nullable T input) {
                try {
                    return base.apply(input);
                }
                catch (Throwable t) {
                    SafePluginPointAccess.handleException(t);
                    return false;
                }
            }
        };
    }

    public static <T> Supplier<T> safe(final Supplier<T> base) {
        return new Supplier<T>(){

            public T get() {
                try {
                    return base.get();
                }
                catch (Throwable t) {
                    return SafePluginPointAccess.handleException(t);
                }
            }
        };
    }

    public static <F, T> Function<F, T> safe(final Function<F, T> base) {
        return new Function<F, T>(){

            public T apply(F from) {
                try {
                    return base.apply(from);
                }
                catch (Throwable t) {
                    return SafePluginPointAccess.handleException(t);
                }
            }
        };
    }

    @Nullable
    public static <T> T handleError(Error e, ModuleDescriptor moduleDescriptor, Object module) throws Error {
        if (e instanceof LinkageError) {
            String msg = moduleDescriptor == null ? String.format("A LinkageError indicates that plugin code was compiled with outdated versions.  Unable to run plugin code because of '%s - %s'.", SafePluginPointAccess.getClassName(e), e.getMessage()) : (module == null ? String.format("A LinkageError indicates that plugin code was compiled with outdated versions.  This is for descriptor '%s' of class '%s' because of '%s - %s'.  Continuing...", SafePluginPointAccess.completeKey(moduleDescriptor), SafePluginPointAccess.getClassName(moduleDescriptor), SafePluginPointAccess.getClassName(e), e.getMessage()) : String.format("A LinkageError indicates that plugin code was compiled with outdated versions.  Unable to access module of type '%s' in descriptor '%s' of class '%s' because of '%s - %s'.  Continuing...", SafePluginPointAccess.getClassName(module), SafePluginPointAccess.completeKey(moduleDescriptor), SafePluginPointAccess.getClassName(moduleDescriptor), SafePluginPointAccess.getClassName(e), e.getMessage()));
            SafePluginPointAccess.logException(msg, e, SafePluginPointAccess.getLogger(moduleDescriptor, module));
            return null;
        }
        throw e;
    }

    @Nullable
    public static <T> T handleException(Throwable e, ModuleDescriptor moduleDescriptor, Object module) throws Error {
        if (e instanceof Error) {
            return SafePluginPointAccess.handleError((Error)e, moduleDescriptor, module);
        }
        String msg = moduleDescriptor == null ? String.format("Unable to run plugin code because of '%s - %s'.", SafePluginPointAccess.getClassName(e), e.getMessage()) : (module == null ? String.format("Unable to access module for descriptor '%s' of class '%s' because of '%s - %s'.  Continuing...", SafePluginPointAccess.completeKey(moduleDescriptor), SafePluginPointAccess.getClassName(moduleDescriptor), SafePluginPointAccess.getClassName(e), e.getMessage()) : String.format("Unable to access module of type '%s' in descriptor '%s' of class '%s' because of '%s - %s'.  Continuing...", SafePluginPointAccess.getClassName(module), SafePluginPointAccess.completeKey(moduleDescriptor), SafePluginPointAccess.getClassName(moduleDescriptor), SafePluginPointAccess.getClassName(e), e.getMessage()));
        SafePluginPointAccess.logException(msg, e, SafePluginPointAccess.getLogger(moduleDescriptor, module));
        return null;
    }

    @Nullable
    public static <T> T handleError(Error e) throws Error {
        return SafePluginPointAccess.handleError(e, null, null);
    }

    @Nullable
    public static <T> T handleError(Error e, ModuleDescriptor moduleDescriptor) throws Error {
        return SafePluginPointAccess.handleError(e, moduleDescriptor, null);
    }

    @Nullable
    public static <T> T handleException(Throwable e) throws Error {
        return SafePluginPointAccess.handleException(e, null, null);
    }

    @Nullable
    public static <T> T handleException(Throwable e, ModuleDescriptor moduleDescriptor) throws Error {
        return SafePluginPointAccess.handleException(e, moduleDescriptor, null);
    }

    private <MT, D extends ModuleDescriptor<MT>> void invokeModule(PluginPointVisitor<D, MT> visitor, D moduleDescriptor, MT module) {
        try {
            visitor.visit(moduleDescriptor, module);
        }
        catch (Throwable t) {
            SafePluginPointAccess.handleException(t);
        }
    }

    private <MT, D extends ModuleDescriptor<MT>> List<D> getModuleDescriptors(Class<D> moduleDescriptorClass) {
        if (this.pluginAccessor == null) {
            throw new IllegalStateException("If you are going to call on the PluginAccessor then you must build this object with one!");
        }
        return this.pluginAccessor.getEnabledModuleDescriptorsByClass(moduleDescriptorClass);
    }

    private static <D extends ModuleDescriptor<MT>, MT> Logger getLogger(D moduleDescriptor, MT module) {
        Class<Object> logClass = module != null ? module.getClass() : (moduleDescriptor != null ? moduleDescriptor.getClass() : SafePluginPointAccess.class);
        return LoggerFactory.getLogger(logClass);
    }

    private static Logger getLogger() {
        return LoggerFactory.getLogger(SafePluginPointAccess.class);
    }

    private static void logException(String msg, Throwable e, Logger log) {
        log.warn(msg);
        if (log.isDebugEnabled()) {
            log.debug(msg, e);
        }
    }

    private static <MT, D extends ModuleDescriptor<MT>> String completeKey(D moduleDescriptor) {
        if (moduleDescriptor == null) {
            return "NULL";
        }
        return moduleDescriptor.getCompleteKey();
    }

    private static String getClassName(Object o) {
        if (o == null) {
            return "NULL";
        }
        if (o instanceof Class) {
            return ((Class)o).getName();
        }
        return o.getClass().getName();
    }

    private <MT> ArrayList<MT> singleList(MT module) {
        ArrayList<MT> modules = new ArrayList<MT>();
        modules.add(module);
        return modules;
    }

    private static class AccumulatingVisitor<D extends ModuleDescriptor<MT>, MT, RT>
    implements PluginPointVisitor<D, MT> {
        private final List<RT> results = Lists.newArrayList();
        private final PluginPointFunction<D, MT, RT> callback;

        private AccumulatingVisitor(PluginPointFunction<D, MT, RT> callback) {
            this.callback = callback;
        }

        @Override
        public void visit(D moduleDescriptor, MT module) {
            RT result = this.callback.onModule(moduleDescriptor, module);
            this.results.add(result);
        }

        private List<RT> getResults() {
            return this.results;
        }
    }
}

