/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.crowd.support;

import com.atlassian.crowd.model.directory.DirectoryImpl;
import com.google.common.collect.Ordering;
import java.util.Map;

final class SupportInformationBuilder {
    private final StringBuilder builder = new StringBuilder(1000);

    SupportInformationBuilder() {
    }

    public void addHeading(String heading) {
        this.builder.append("=== ").append(heading).append(" ===\n");
    }

    public void addField(String name, Object value) {
        this.builder.append(name).append(": ").append(value).append("\n");
    }

    public void newLine() {
        this.builder.append("\n");
    }

    public void addAttributes(String name, Map<String, String> attributes) {
        this.builder.append(name).append(": ").append("\n");
        for (String key : Ordering.natural().sortedCopy(attributes.keySet())) {
            String value = DirectoryImpl.PASSWORD_ATTRIBUTES.contains(key) ? "********" : "\"" + attributes.get(key) + "\"";
            this.builder.append("    \"").append(key).append("\": ").append(value).append("\n");
        }
    }

    public String build() {
        return this.builder.toString();
    }
}

