/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.taglib.ui.table.renderer;

import java.text.DecimalFormat;
import webwork.view.taglib.ui.table.WebTable;
import webwork.view.taglib.ui.table.renderer.AbstractCellRenderer;

public class NumericCellRenderer
extends AbstractCellRenderer {
    String _positiveColor = null;
    String _negativeColor = null;
    String _formatString = null;
    DecimalFormat _formater = new DecimalFormat();

    @Override
    public String getCellValue(WebTable table, Object data, int row, int col) {
        StringBuffer retVal = new StringBuffer(128);
        if (data == null) {
            return "";
        }
        if (data instanceof Number) {
            double cellValue = ((Number)data).doubleValue();
            if (cellValue >= 0.0) {
                this.processNumber(retVal, this._positiveColor, cellValue);
            } else {
                this.processNumber(retVal, this._negativeColor, cellValue);
            }
            return retVal.toString();
        }
        return data.toString();
    }

    protected void processNumber(StringBuffer buf, String color, double cellValue) {
        if (color != null) {
            buf.append(" <font color='").append(color).append("'>");
        }
        buf.append(this._formater.format(cellValue));
        if (color != null) {
            buf.append("</font>");
        }
    }

    public void setPositiveColor(String color) {
        this._positiveColor = color;
    }

    public void setNegativeColor(String color) {
        this._negativeColor = color;
    }

    public void setFormatString(String format) {
        this._formatString = format;
        this._formater.applyPattern(this._formatString);
    }
}

