/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.taglib.ui;

import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.context.Context;
import webwork.config.Configuration;
import webwork.util.ContainUtil;
import webwork.view.taglib.IncludeTag;
import webwork.view.taglib.ParamTag;
import webwork.view.taglib.WebWorkBodyTagSupport;
import webwork.view.velocity.VelocityHelper;

public class FragmentTag
extends WebWorkBodyTagSupport
implements ParamTag.Parametric {
    protected static Log log = LogFactory.getLog(FragmentTag.class);
    protected String themeAttr;
    protected String templateAttr;
    protected String templateSuffix;
    protected String theme;
    protected Map params = new HashMap();
    protected String templateDir;

    public String getTemplate() {
        return "text";
    }

    public String getTheme() {
        if (this.theme == null || this.theme == "") {
            this.theme = (String)this.pageContext.findAttribute("theme");
        }
        if (this.theme == null || this.theme == "") {
            this.theme = Configuration.getString("webwork.ui.theme");
        }
        return this.theme;
    }

    public String getTemplateSuffix() {
        if (this.templateSuffix == null || this.templateSuffix == "") {
            this.templateSuffix = Configuration.getString("webwork.ui.templateSuffix");
        }
        return this.templateSuffix;
    }

    public String getTemplateDir() {
        if (this.templateDir == null || this.templateDir == "") {
            this.templateDir = (String)this.pageContext.findAttribute("templateDir");
        }
        if (this.templateDir == null || this.templateDir == "") {
            this.templateDir = Configuration.getString("webwork.ui.templateDir");
        }
        if (this.templateDir == null || this.templateDir == "") {
            this.templateDir = "template";
        }
        return this.templateDir;
    }

    public void setTheme(String aName) {
        this.themeAttr = aName;
    }

    public void setTemplate(String aName) {
        this.templateAttr = aName;
    }

    @Override
    public void addParameter(String name, Object value) {
        this.addParameterInternal(name, value);
    }

    private void addParameterInternal(String name, Object value) {
        this.params.put(name, value);
    }

    public Map getParameters() {
        return this.params;
    }

    public boolean memberOf(Object obj1, Object obj2) {
        return ContainUtil.contains(obj1, obj2);
    }

    @Override
    public int doEndTag() throws JspException {
        String template;
        if (this.themeAttr != null) {
            this.theme = (String)this.findValue(this.themeAttr);
        }
        if ((template = this.templateAttr) == null) {
            template = this.getTemplate() + "." + this.getTemplateSuffix();
        }
        this.getStack().pushValue(this);
        try {
            String templatePath = "/" + this.getTemplateDir() + "/" + this.getTheme() + "/" + template;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using template:" + templatePath));
            }
            if (templatePath.endsWith(".vm")) {
                Context c = VelocityHelper.getContext(this.pageContext.getServletContext(), this.pageContext.getRequest(), this.pageContext.getResponse());
                VelocityHelper.merge(c, templatePath, (Writer)this.pageContext.getOut());
            } else {
                IncludeTag.include(templatePath, this.pageContext);
            }
            int n = 6;
            return n;
        }
        catch (Exception e) {
            throw new JspTagException("Including component failed:" + this.toString(e));
        }
        finally {
            this.getStack().popValue();
            this.params = new HashMap();
        }
    }
}

