/*
 * Decompiled with CFR 0.152.
 */
package webwork.view.taglib.ui;

import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspTagException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.velocity.context.Context;
import webwork.config.Configuration;
import webwork.util.BeanUtil;
import webwork.util.ContainUtil;
import webwork.view.taglib.IncludeTag;
import webwork.view.taglib.ParamTag;
import webwork.view.taglib.WebWorkBodyTagSupport;
import webwork.view.taglib.ui.QuoteRemover;
import webwork.view.velocity.VelocityHelper;

public class ComponentTag
extends WebWorkBodyTagSupport
implements ParamTag.Parametric {
    protected static Log log = LogFactory.getLog(ComponentTag.class);
    protected String themeAttr;
    protected String templateAttr;
    protected String templateSuffix;
    protected String nameAttr;
    protected String valueAttr;
    protected String labelAttr;
    protected String labelPositionAttr;
    protected String theme;
    protected String tabindex;
    protected String title;
    protected String mandatory;
    protected String accesskey;
    protected Map<String, Object> params = new HashMap<String, Object>();
    protected String templateDir;

    public String getTemplate() {
        return "text";
    }

    public String getTheme() {
        if (this.theme == null || this.theme.equals("")) {
            this.theme = (String)this.pageContext.findAttribute("theme");
        }
        if (this.theme == null || this.theme.equals("")) {
            this.theme = Configuration.getString("webwork.ui.theme");
        }
        return this.theme;
    }

    public String getTemplateSuffix() {
        if (this.templateSuffix == null || this.templateSuffix.equals("")) {
            this.templateSuffix = Configuration.getString("webwork.ui.templateSuffix");
        }
        return this.templateSuffix;
    }

    public String getTemplateDir() {
        if (this.templateDir == null || this.templateDir.equals("")) {
            this.templateDir = (String)this.pageContext.findAttribute("templateDir");
        }
        if (this.templateDir == null || this.templateDir.equals("")) {
            this.templateDir = Configuration.getString("webwork.ui.templateDir");
        }
        if (this.templateDir == null || this.templateDir.equals("")) {
            this.templateDir = "template";
        }
        return this.templateDir;
    }

    public void setTheme(String aName) {
        this.themeAttr = aName;
    }

    public void setTemplate(String aName) {
        this.templateAttr = aName;
    }

    public void setLabel(String aLabel) {
        this.labelAttr = aLabel;
    }

    public void setName(String aName) {
        this.nameAttr = aName;
    }

    public void setValue(String aName) {
        this.valueAttr = aName;
    }

    public void setLabelposition(String aLabelPosition) {
        this.labelPositionAttr = aLabelPosition;
    }

    public void setTabindex(String tabindex) {
        this.tabindex = tabindex;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setAccesskey(String accesskey) {
        this.accesskey = accesskey;
    }

    public void setMandatory(String mandatory) {
        this.mandatory = mandatory;
    }

    @Override
    public void addParameter(String name, Object value) {
        this.addParameterInternal(name, value);
    }

    private void addParameterInternal(String name, Object value) {
        this.params.put(name, value);
    }

    public Map getParameters() {
        return this.params;
    }

    public boolean memberOf(Object obj1, Object obj2) {
        return ContainUtil.contains(obj1, obj2);
    }

    @Override
    public int doEndTag() throws JspException {
        String template;
        if (this.themeAttr != null) {
            this.theme = (String)this.findValue(this.themeAttr);
        }
        if ((template = this.templateAttr) == null) {
            template = this.getTemplate() + "." + this.getTemplateSuffix();
        }
        if (this.labelAttr != null) {
            this.addParameterInternal("label", this.findValue(this.labelAttr));
        }
        Object evaluationOfNameAttr = null;
        if (this.nameAttr != null && (evaluationOfNameAttr = this.findValue(this.nameAttr)) != null) {
            this.addParameterInternal("name", evaluationOfNameAttr);
        }
        if (this.valueAttr == null) {
            if (evaluationOfNameAttr != null) {
                this.addParameterInternal("nameValue", this.findValue(BeanUtil.toStringValue(evaluationOfNameAttr)));
            }
        } else {
            this.addParameterInternal("nameValue", this.findValue(this.valueAttr));
        }
        if (this.labelPositionAttr == null) {
            this.labelPositionAttr = "'center'";
        }
        this.addParameterInternal("labelposition", this.findValue(this.labelPositionAttr));
        if (this.getId() != null) {
            this.addParameterInternal("id", this.removeSingleQuotes(this.getId()));
        }
        if (this.tabindex != null) {
            this.addParameterInternal("tabindex", this.findValue(this.tabindex));
        }
        if (this.title != null) {
            this.addParameterInternal("title", this.findValue(this.title));
        }
        if (this.accesskey != null) {
            this.addParameterInternal("accesskey", this.findValue(this.accesskey));
        }
        if (this.mandatory != null) {
            this.addParameterInternal("mandatory", this.findValue(this.mandatory));
        }
        this.getStack().pushValue(this);
        try {
            String templatePath = "/" + this.getTemplateDir() + "/" + this.getTheme() + "/" + template;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Using template:" + templatePath));
            }
            if (templatePath.endsWith(".vm")) {
                Context c = VelocityHelper.getContext(this.pageContext.getServletContext(), this.pageContext.getRequest(), this.pageContext.getResponse());
                VelocityHelper.merge(c, templatePath, (Writer)this.pageContext.getOut());
            } else {
                IncludeTag.include(templatePath, this.pageContext);
            }
            int n = 6;
            return n;
        }
        catch (Exception e) {
            throw new JspTagException("Including component failed:" + this.toString(e));
        }
        finally {
            this.getStack().popValue();
            this.params = new HashMap<String, Object>();
        }
    }

    private String removeSingleQuotes(String s) {
        return QuoteRemover.removeSingleQuotes(s);
    }
}

