/*
 * Decompiled with CFR 0.152.
 */
package webwork.util;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.io.StringReader;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import webwork.action.ActionContext;
import webwork.expr.ParseException;
import webwork.expr.Parser;
import webwork.util.BeanUtil;
import webwork.util.InjectionUtils;
import webwork.util.Query;
import webwork.util.QuerySegment;
import webwork.util.SimpleTest;

public class ValueStack
implements Iterable<Object> {
    public static final String STACK_NAME = "webwork.result";
    public static final String WEBWORK_VALUE_STACK_LOG_EXCEPTIONS = "webwork.valueStack.log.exceptions";
    protected static final Map<Class<?>, Map<String, MethodInfo[]>> classes = new ConcurrentHashMap();
    private static final Log log = LogFactory.getLog(ValueStack.class);
    private final List<Object> valueList = new ArrayList<Object>();
    private Parser parser;

    public static void clearMethods() {
        classes.clear();
    }

    public void pushValue(Object value) {
        this.valueList.add(value);
    }

    public Object peek() {
        int size = this.valueList.size();
        if (size < 1) {
            return null;
        }
        return this.valueList.get(size - 1);
    }

    public Object popValue() {
        int size = this.valueList.size();
        if (size < 1) {
            return null;
        }
        return this.valueList.remove(size - 1);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.valueList.iterator();
    }

    public int size() {
        return this.valueList.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean test(String expression) {
        if (expression == null) {
            throw new NullPointerException("Expression cannot be null.");
        }
        boolean answer = false;
        try {
            SimpleTest simpleTest = SimpleTest.getSimpleTest(expression);
            if (simpleTest != null) {
                answer = simpleTest.test(this, null, null);
            } else {
                Parser expressionLanguageParser = this.getParser(expression);
                answer = expressionLanguageParser.test();
            }
        }
        catch (ParseException expressionParsingException) {
            throw new IllegalArgumentException("An error occurred parsing the following webwork expression: '" + expression + "'", expressionParsingException);
        }
        return answer;
    }

    protected Object findInContext(String id) {
        return null;
    }

    protected Object unwrap(Object value) {
        if (value instanceof ValueHolder) {
            return ((ValueHolder)value).getValue();
        }
        return value;
    }

    public Object findValue(String query) throws IllegalArgumentException {
        Query q = query == null || query.length() == 0 || query.length() == 1 && query.charAt(0) == '.' ? Query.CURRENT : Query.getQuery(query);
        return this.findValue(q);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object findValue(Query q) throws IllegalArgumentException {
        Object value;
        QuerySegment[] segments = q.getSegments();
        QuerySegment segment = segments[0];
        int segmentIdx = 1;
        int stackIdx = 0;
        switch (segment.getType()) {
            case 3: {
                int size = this.valueList.size();
                if (size < 1) {
                    return null;
                }
                value = this.valueList.get(size - 1);
                if ((segment = segments[segmentIdx++]) != null) break;
                return this.unwrap(value);
            }
            case 0: {
                return segment.getId();
            }
            case 12: {
                return segment.getValues().get(0);
            }
            case 6: {
                value = this.findInContext(segment.getId());
                if (value == null) {
                    return null;
                }
                if ((segment = segments[segmentIdx++]) != null) break;
                return this.unwrap(value);
            }
            case 7: {
                return this.getParameter(segment.getId());
            }
            case 1: {
                return Boolean.TRUE;
            }
            case 2: {
                return Boolean.FALSE;
            }
            case 13: {
                return null;
            }
            case 14: {
                List<Object> concatList = segment.getValues();
                StringBuilder buf = new StringBuilder();
                int i = 0;
                while (true) {
                    if (i >= concatList.size()) {
                        return buf.toString();
                    }
                    Object concatValue = this.findValue((Query)concatList.get(i));
                    buf.append(BeanUtil.toStringValue(concatValue));
                    ++i;
                }
            }
            case 5: {
                if (this.valueList.size() < 1) {
                    return null;
                }
                value = this.valueList.get(0);
                if ((segment = segments[segmentIdx++]) != null) break;
                return this.unwrap(value);
            }
            default: {
                int size = this.valueList.size();
                if (size < 1) {
                    return null;
                }
                stackIdx = size - 1;
                value = this.valueList.get(stackIdx);
            }
        }
        int saveSegmentIdx = segmentIdx;
        boolean gotResult = false;
        while (true) {
            int workStackIdx = stackIdx;
            if (value != null) {
                block30: do {
                    gotResult = false;
                    switch (segment.getType()) {
                        case 8: {
                            value = this.unwrap(value);
                            if (value == null) break block30;
                            try {
                                MethodInfo[] methods = this.getMethod(value.getClass(), segment.getId());
                                if (methods == null || methods[0].getNrOfParameters() != 0) break block30;
                                try {
                                    value = InjectionUtils.invoke(methods[0].getMethod(), value, null);
                                }
                                catch (Exception e) {
                                    this.logValueStackException(e, q);
                                    throw e;
                                }
                                gotResult = true;
                                break;
                            }
                            catch (Exception e) {
                                break block30;
                            }
                        }
                        case 10: {
                            value = this.unwrap(value);
                            if (value == null) break block30;
                            Object[] params = null;
                            MethodInfo target = null;
                            try {
                                MethodInfo[] methods = this.getMethod(value.getClass(), segment.getId());
                                if (methods == null) break block30;
                                List<Object> list = segment.getValues();
                                int vsize = list.size();
                                params = new Object[vsize];
                                for (int i = 0; i < vsize; ++i) {
                                    Object param;
                                    params[i] = param = this.findValue((Query)list.get(i));
                                }
                                target = this.findMethod(methods, params);
                                if (target == null) {
                                    log.error((Object)("No method found for " + segment.getId() + " with parameters " + Arrays.asList(this.getParameterClasses(params)) + " in class " + value.getClass()));
                                    break block30;
                                }
                                Class<?>[] parameterTypes = target.getParameterTypes();
                                int paramCount = parameterTypes.length;
                                for (int i = 0; i < paramCount; ++i) {
                                    Object param;
                                    PropertyEditor pe;
                                    Class<?> parameterClass = parameterTypes[i];
                                    Object parami = params[i];
                                    if (parameterClass.equals(String.class)) continue;
                                    if (parami == null) {
                                        if (!parameterClass.isPrimitive()) continue;
                                        break block30;
                                    }
                                    if (parameterClass.equals(parami.getClass()) || parameterClass.isAssignableFrom(parami.getClass()) || (pe = BeanUtil.getPropertyEditor(parameterClass)) == null) continue;
                                    params[i] = param = BeanUtil.getAsValue(pe, parami.toString());
                                }
                                value = InjectionUtils.invoke(target.getMethod(), value, params);
                                gotResult = true;
                                break;
                            }
                            catch (IllegalArgumentException e) {
                                log.error((Object)("Illegal parameters invoking " + value.getClass() + "." + target.getMethod().getName() + "(" + Arrays.asList(this.getParameterClasses(params)) + ")"));
                                break block30;
                            }
                            catch (Exception e) {
                                void var14_26;
                                Exception exception = e;
                                if (e instanceof InvocationTargetException) {
                                    Throwable throwable = ((InvocationTargetException)e).getTargetException();
                                }
                                log.error((Object)("METHOD: \"" + segment.getId() + "\", exception: "), (Throwable)var14_26);
                                break block30;
                            }
                        }
                        case 9: {
                            Object key;
                            value = this.unwrap(value);
                            if (value == null || (key = this.findValue(segment.getQuery())) == null) break block30;
                            if (value instanceof Map) {
                                value = ((Map)value).get(key);
                                gotResult = true;
                                break;
                            }
                            if (value instanceof List) {
                                value = ((List)value).get((Integer)key);
                                gotResult = true;
                                break;
                            }
                            if (value.getClass().isArray()) {
                                value = Array.get(value, (Integer)key);
                                gotResult = true;
                                break;
                            }
                            if (value instanceof ResourceBundle) {
                                value = ((ResourceBundle)value).getObject(key.toString());
                                gotResult = true;
                                break;
                            }
                            if (!(value instanceof Collection)) break block30;
                            value = ((Collection)value).toArray()[(Integer)key];
                            gotResult = true;
                            break;
                        }
                        case 4: {
                            if (--workStackIdx < 0) break block30;
                            value = this.valueList.get(workStackIdx);
                            gotResult = true;
                            break;
                        }
                        case 11: {
                            try {
                                Object object = this.findValue(segment.getQuery());
                                if (object == null) break block30;
                                value = this.findValue(object.toString());
                                gotResult = true;
                                break;
                            }
                            catch (Exception exception) {
                                break block30;
                            }
                        }
                    }
                } while ((segment = segments[segmentIdx++]) != null);
            }
            if (gotResult || stackIdx <= 0) break;
            value = this.valueList.get(--stackIdx);
            segmentIdx = saveSegmentIdx;
            segment = segments[segmentIdx - 1];
        }
        if (!gotResult) {
            return null;
        }
        return this.unwrap(value);
    }

    private void logValueStackException(Exception e, Query q) {
        boolean logException = true;
        try {
            String logExceptionValue = System.getProperty(WEBWORK_VALUE_STACK_LOG_EXCEPTIONS);
            if (logExceptionValue != null) {
                logException = Boolean.parseBoolean(logExceptionValue);
            }
        }
        catch (Exception t) {
            // empty catch block
        }
        if (logException) {
            log.error((Object)q.toString(), (Throwable)e);
        }
    }

    private Object[] getParameterClasses(Object[] params) {
        Object[] classes = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            classes[i] = params[i] != null ? params[i].getClass() : null;
        }
        return classes;
    }

    public String toString() {
        String str = "Value stack\n";
        str = str + "===========\n";
        for (int i = 0; i < this.valueList.size(); ++i) {
            Object val = this.valueList.get(i);
            str = str + (val == null ? "null\n" : val.toString() + "\n");
        }
        str = str + "===========\n";
        return str;
    }

    private Parser getParser(String expression) {
        if (this.parser == null) {
            this.parser = new Parser(new StringReader(expression));
            this.parser.setValueStack(this);
        } else {
            this.parser.ReInit(new StringReader(expression));
        }
        return this.parser;
    }

    protected MethodInfo[] getMethod(Class<?> cl, String name) throws IntrospectionException {
        Map<String, MethodInfo[]> methods = classes.get(cl);
        if (methods == null) {
            Method[] getters;
            methods = new ConcurrentHashMap<String, MethodInfo[]>();
            BeanInfo bi = Introspector.getBeanInfo(cl);
            PropertyDescriptor[] pd = bi.getPropertyDescriptors();
            for (int i = 0; i < pd.length; ++i) {
                Method method = pd[i].getReadMethod();
                if (method == null) continue;
                if (!Modifier.isPublic(cl.getModifiers())) {
                    Class<?>[] interfaces;
                    for (Class<?> interface1 : interfaces = bi.getBeanDescriptor().getBeanClass().getInterfaces()) {
                        try {
                            method = interface1.getMethod(method.getName(), new Class[0]);
                            break;
                        }
                        catch (Exception e) {
                        }
                    }
                    if (method.equals(pd[i].getReadMethod())) {
                        AccessibleObject.setAccessible(new AccessibleObject[]{method}, true);
                    }
                }
                methods.put(pd[i].getName(), new MethodInfo[]{new MethodInfo(method)});
            }
            for (Method method : getters = cl.getMethods()) {
                MethodInfo[] newlist;
                String methodName;
                if (method.getName().startsWith("set") || method.getReturnType().equals(Void.TYPE)) continue;
                if (!Modifier.isPublic(cl.getModifiers())) {
                    Class<?>[] interfaces;
                    for (Class<?> interface1 : interfaces = cl.getInterfaces()) {
                        try {
                            method = interface1.getMethod(method.getName(), method.getParameterTypes());
                            break;
                        }
                        catch (Exception e) {
                        }
                    }
                    if (method.equals(method)) {
                        AccessibleObject.setAccessible(new AccessibleObject[]{method}, true);
                    }
                }
                if ((methodName = method.getName()).startsWith("get")) {
                    methodName = Introspector.decapitalize(methodName.substring(3));
                } else if (methodName.startsWith("is")) {
                    methodName = Introspector.decapitalize(methodName.substring(2));
                }
                MethodInfo[] current = methods.get(methodName);
                if (current == null) {
                    newlist = new MethodInfo[]{new MethodInfo(method)};
                } else {
                    newlist = new MethodInfo[current.length + 1];
                    System.arraycopy(current, 0, newlist, 0, current.length);
                    newlist[current.length] = new MethodInfo(method);
                }
                methods.put(methodName, newlist);
            }
            classes.put(cl, methods);
        }
        MethodInfo[] nameMethods = methods.get(name);
        return nameMethods;
    }

    protected MethodInfo findMethod(MethodInfo[] m, Object[] params) {
        if (m.length == 1) {
            return m[0].getNrOfParameters() == params.length ? m[0] : null;
        }
        MethodInfo oneMatch = null;
        ArrayList<MethodInfo> match = null;
        int noOfArgument = params.length;
        for (MethodInfo element : m) {
            if (element.getNrOfParameters() != noOfArgument) continue;
            if (oneMatch == null) {
                oneMatch = element;
                continue;
            }
            if (match == null) {
                match = new ArrayList<MethodInfo>();
                match.add(oneMatch);
            }
            match.add(element);
        }
        if (match == null) {
            return oneMatch;
        }
        MethodInfo exact = null;
        ArrayList<MethodInfo> close = new ArrayList<MethodInfo>();
        ArrayList<MethodInfo> convert = new ArrayList<MethodInfo>();
        for (MethodInfo current : match) {
            Class<?>[] paramClass = current.getParameterTypes();
            boolean exactMatch = true;
            boolean closeMatch = true;
            boolean convertable = true;
            for (int j = 0; j < paramClass.length; ++j) {
                Class<?> p = params[j].getClass();
                if (paramClass[j].getName().equals(p.getName())) continue;
                if (paramClass[j].isAssignableFrom(p)) {
                    exactMatch = false;
                    continue;
                }
                exactMatch = false;
                closeMatch = false;
                try {
                    PropertyEditor pe = BeanUtil.getPropertyEditor(paramClass[j]);
                    if (pe == null) {
                        convertable = false;
                    } else {
                        BeanUtil.getAsValue(pe, params[j].toString());
                    }
                }
                catch (Exception e) {
                    convertable = false;
                }
                if (!convertable) break;
            }
            if (exactMatch) {
                exact = current;
                break;
            }
            if (closeMatch) {
                close.add(current);
                continue;
            }
            if (!convertable) continue;
            convert.add(current);
        }
        if (exact != null) {
            return exact;
        }
        if (close.size() > 0) {
            return (MethodInfo)close.get(0);
        }
        if (convert.size() > 0) {
            return (MethodInfo)convert.get(0);
        }
        return null;
    }

    protected Object getParameter(String aName) {
        return ActionContext.getParameters().get(aName);
    }

    public static interface ValueHolder {
        public Object getValue();
    }

    private static class MethodInfo {
        private final Method _method;
        private final Class<?>[] _parameterTypes;
        private final int _nrOfParameters;

        public MethodInfo(Method method) {
            this._method = method;
            this._parameterTypes = method.getParameterTypes();
            this._nrOfParameters = this._parameterTypes.length;
        }

        public Method getMethod() {
            return this._method;
        }

        public Class<?>[] getParameterTypes() {
            return this._parameterTypes;
        }

        public int getNrOfParameters() {
            return this._nrOfParameters;
        }
    }
}

