/*
 * Decompiled with CFR 0.152.
 */
package webwork.config;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import webwork.config.ConfigurationInterface;
import webwork.config.DefaultConfiguration;
import webwork.config.WebworkConfigurationNotFoundException;

public class CachingConfiguration
extends DefaultConfiguration {
    protected Map configurationMap;

    public CachingConfiguration() {
        this.configurationMap = this.getConfigurationMap(this.config);
    }

    protected Map getConfigurationMap(ConfigurationInterface configObject) {
        Iterator it = configObject.listImpl();
        HashMap<String, Object> configMap = new HashMap<String, Object>();
        while (it.hasNext()) {
            String key = (String)it.next();
            Object value = configObject.getImpl(key);
            configMap.put(key, value);
        }
        return configMap;
    }

    @Override
    public Object getImpl(String aName) throws IllegalArgumentException {
        Object value = this.configurationMap.get(aName);
        if (value == null) {
            throw new WebworkConfigurationNotFoundException(this.getClass(), "No such setting", aName);
        }
        return value;
    }

    @Override
    public void setImpl(String aName, Object aValue) {
        this.configurationMap.put(aName, aValue);
    }

    @Override
    public Iterator listImpl() {
        return this.configurationMap.keySet().iterator();
    }
}

