/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.scheduler.caesium.impl;

import com.atlassian.scheduler.caesium.impl.QueuedJob;
import com.atlassian.scheduler.caesium.impl.SchedulerQueue;
import com.atlassian.util.concurrent.Assertions;
import com.atlassian.util.concurrent.Sink;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SchedulerQueueWorker
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(SchedulerQueueWorker.class);
    private final SchedulerQueue queue;
    private final Sink<QueuedJob> executeJob;

    SchedulerQueueWorker(SchedulerQueue queue, Sink<QueuedJob> executeJob) {
        this.queue = (SchedulerQueue)Assertions.notNull((String)"queue", (Object)queue);
        this.executeJob = (Sink)Assertions.notNull((String)"executeJob", executeJob);
    }

    @Override
    public void run() {
        while (true) {
            try {
                while (this.executeNextJob()) {
                }
            }
            catch (InterruptedException ie) {
                LOG.debug("Scheduler queue worker was interrupted; ignoring...", (Throwable)ie);
                continue;
            }
            break;
        }
        LOG.debug("Shutting down.");
    }

    private boolean executeNextJob() throws InterruptedException {
        QueuedJob job = this.queue.take();
        if (job == null) {
            LOG.debug("The scheduler queue has closed.");
            return false;
        }
        this.executeJob(job);
        return true;
    }

    private void executeJob(QueuedJob job) {
        try {
            this.executeJob.consume((Object)job);
        }
        catch (Throwable e) {
            LOG.error("Unhandled exception thrown by job {}", (Object)job, (Object)e);
        }
    }
}

