/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.vcache.internal.legacy;

import com.atlassian.cache.Cache;
import com.atlassian.vcache.ExternalCacheException;
import com.atlassian.vcache.Marshaller;
import com.atlassian.vcache.PutPolicy;
import com.atlassian.vcache.internal.core.cas.IdentifiedData;
import com.atlassian.vcache.internal.core.cas.IdentifiedUtils;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;

class LegacyUtils {
    LegacyUtils() {
    }

    static boolean directPut(String externalKey, IdentifiedData identifiedData, PutPolicy policy, Cache<String, IdentifiedData> delegate, boolean avoidCasOps) {
        PutPolicy convertedPolicy = avoidCasOps ? PutPolicy.PUT_ALWAYS : policy;
        switch (convertedPolicy) {
            case ADD_ONLY: {
                return delegate.putIfAbsent((Object)externalKey, (Object)identifiedData) == null;
            }
            case PUT_ALWAYS: {
                delegate.put((Object)externalKey, (Object)identifiedData);
                return true;
            }
            case REPLACE_ONLY: {
                IdentifiedData existingData = (IdentifiedData)delegate.get((Object)externalKey);
                return existingData != null && delegate.replace((Object)externalKey, (Object)existingData, (Object)identifiedData);
            }
        }
        throw new IllegalArgumentException("Unknown put policy: " + convertedPolicy);
    }

    @Nonnull
    static ExternalCacheException mapException(Exception ex) {
        return new ExternalCacheException(ExternalCacheException.Reason.UNCLASSIFIED_FAILURE, (Throwable)ex);
    }

    @Nonnull
    static <V> Map<String, Optional<V>> directGetBulk(Set<String> externalKeys, Cache<String, IdentifiedData> delegate, Optional<Marshaller<V>> valueMarshaller) {
        return StreamSupport.stream(externalKeys.spliterator(), false).distinct().collect(Collectors.toMap(Objects::requireNonNull, k -> IdentifiedUtils.unmarshall((IdentifiedData)((IdentifiedData)delegate.get(k)), (Optional)valueMarshaller)));
    }
}

