/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding.data;

import com.atlassian.jira.avatar.Avatar;
import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.onboarding.data.AbstractOnboardingDataProvider;
import com.atlassian.jira.project.type.ProjectType;
import com.atlassian.jira.project.type.ProjectTypeManager;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class NutshellDataProvider
extends AbstractOnboardingDataProvider {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final AvatarService avatarService;
    private final ProjectTypeManager projectTypeManager;

    public NutshellDataProvider(@ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport AvatarService avatarService, @ComponentImport ProjectTypeManager projectTypeManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.avatarService = avatarService;
        this.projectTypeManager = projectTypeManager;
    }

    @Override
    JSONObject getJsonData() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        HashMap values = Maps.newHashMap();
        values.put("defaultProjectAvatarUrl", this.getDefaultProjectAvatarUrl());
        values.put("userFullname", user.getDisplayName());
        this.addProjectTypeAvatars(values);
        return new JSONObject((Map)values);
    }

    private String getDefaultProjectAvatarUrl() {
        return String.valueOf(this.avatarService.getProjectDefaultAvatarAbsoluteURL(Avatar.Size.defaultSize()));
    }

    private void addProjectTypeAvatars(Map<String, Object> values) {
        List allProjectTypes = this.projectTypeManager.getAllProjectTypes();
        Map<String, String> projectTypeAvatars = this.getAvatars(allProjectTypes);
        if (projectTypeAvatars.containsKey("business")) {
            values.put("projectTypeAvatars", projectTypeAvatars);
            values.put("projectType", "business");
        }
    }

    private Map<String, String> getAvatars(List<ProjectType> allProjectTypes) {
        HashMap projectTypeAvatars = Maps.newHashMap();
        for (ProjectType projectType : allProjectTypes) {
            String projectTypeKeyName = projectType.getKey().getKey();
            String projectTypeAvatar = projectType.getIcon();
            projectTypeAvatars.put(projectTypeKeyName, projectTypeAvatar);
        }
        return projectTypeAvatars;
    }
}

