/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding.data;

import com.atlassian.jira.onboarding.data.AbstractOnboardingDataProvider;
import com.atlassian.jira.permission.ProjectPermissions;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.security.PermissionManager;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;

public class NextStepDataProvider
extends AbstractOnboardingDataProvider {
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final PermissionManager permissionManager;

    public NextStepDataProvider(@ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport PermissionManager permissionManager) {
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.permissionManager = permissionManager;
    }

    @Override
    JSONObject getJsonData() {
        ApplicationUser user = this.jiraAuthenticationContext.getUser();
        HashMap values = Maps.newHashMap();
        values.put("canBrowseProjects", this.canBrowseProjects(user));
        values.put("canCreateIssues", this.canCreateIssues(user));
        values.put("canSearchIssues", this.canSearchIssues(user));
        return new JSONObject((Map)values);
    }

    private boolean canCreateIssues(ApplicationUser user) {
        return this.permissionManager.hasProjects(ProjectPermissions.CREATE_ISSUES, user);
    }

    private boolean canBrowseProjects(ApplicationUser user) {
        return this.permissionManager.hasProjects(ProjectPermissions.BROWSE_PROJECTS, user);
    }

    private boolean canSearchIssues(ApplicationUser user) {
        return this.canBrowseProjects(user);
    }
}

