/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding.data;

import com.atlassian.jira.config.LocaleManager;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.onboarding.data.AbstractOnboardingDataProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.util.I18nHelper;
import com.atlassian.jira.util.LocaleParser;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public class ChooseLanguageDataProvider
extends AbstractOnboardingDataProvider {
    private LocaleManager localeManager;
    private I18nHelper i18nHelper;
    private I18nHelper.BeanFactory i18nFactory;
    private JiraAuthenticationContext jiraAuthenticationContext;
    private ApplicationProperties applicationProperties;

    public ChooseLanguageDataProvider(@ComponentImport LocaleManager localeManager, @ComponentImport I18nHelper i18nHelper, @ComponentImport I18nHelper.BeanFactory i18nFactory, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport ApplicationProperties applicationProperties) {
        this.localeManager = localeManager;
        this.i18nHelper = i18nHelper;
        this.i18nFactory = i18nFactory;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.applicationProperties = applicationProperties;
    }

    @Override
    JSONObject getJsonData() {
        Map<String, String> languages = this.getInstalledLocales();
        HashMap translations = Maps.newHashMap();
        for (String locale : languages.keySet()) {
            translations.put(locale, this.getTranslationsFor(locale));
        }
        HashMap values = Maps.newHashMap();
        values.put("languages", languages);
        values.put("translations", translations);
        values.put("defaultLocale", this.applicationProperties.getDefaultLocale().toString());
        values.put("currentLocale", this.jiraAuthenticationContext.getLocale().toString());
        values.put("userPrefKey", "jira.user.locale");
        return new JSONObject((Map)values);
    }

    private Map<String, String> getInstalledLocales() {
        return this.localeManager.getInstalledLocalesWithDefault(this.applicationProperties.getDefaultLocale(), this.i18nHelper);
    }

    private Map<String, String> getTranslationsFor(String localeString) {
        Locale locale = LocaleParser.parseLocale((String)localeString);
        I18nHelper i18n = this.i18nFactory.getInstance(locale);
        HashMap values = Maps.newHashMap();
        values.put("buttonText", i18n.getText("common.forms.continue"));
        values.put("headingText", i18n.getText("onboarding.welcome.user.to.jira", this.jiraAuthenticationContext.getUser().getDisplayName()));
        values.put("introductionText", i18n.getText("onboarding.choose.language.introduction"));
        values.put("titleText", i18n.getText("onboarding.welcome.to.jira"));
        return values;
    }
}

