/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.jira.onboarding.data;

import com.atlassian.jira.avatar.AvatarService;
import com.atlassian.jira.bc.user.search.AssigneeService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.issue.fields.Assignees;
import com.atlassian.jira.issue.fields.option.AssigneeOption;
import com.atlassian.jira.issue.fields.option.AssigneeOptions;
import com.atlassian.jira.issue.fields.option.OptionGroup;
import com.atlassian.jira.issue.fields.option.SelectChild;
import com.atlassian.jira.onboarding.data.AbstractOnboardingDataProvider;
import com.atlassian.jira.security.JiraAuthenticationContext;
import com.atlassian.jira.user.ApplicationUser;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.jira.util.EmailFormatter;
import com.atlassian.jira.util.json.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class AssignIssuesSequenceDataProvider
extends AbstractOnboardingDataProvider {
    private Assignees assignees;
    private final ApplicationProperties applicationProperties;
    private final AssigneeService assigneeService;
    private final AvatarService avatarService;
    private final UserManager userManager;
    private final JiraAuthenticationContext jiraAuthenticationContext;
    private final EmailFormatter emailFormatter;

    public AssignIssuesSequenceDataProvider(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport AssigneeService assigneeService, @ComponentImport AvatarService avatarService, @ComponentImport UserManager userManager, @ComponentImport JiraAuthenticationContext jiraAuthenticationContext, @ComponentImport EmailFormatter emailFormatter) {
        this.applicationProperties = applicationProperties;
        this.assigneeService = assigneeService;
        this.avatarService = avatarService;
        this.userManager = userManager;
        this.jiraAuthenticationContext = jiraAuthenticationContext;
        this.emailFormatter = emailFormatter;
    }

    @Override
    JSONObject getJsonData() {
        ApplicationUser loggedInUser = this.jiraAuthenticationContext.getUser();
        ArrayList issues = Lists.newArrayList();
        ArrayList suggestedUsers = Lists.newArrayList((Object[])new ApplicationUser[]{loggedInUser});
        AssigneeOptions options = this.getAssigneesObject().makeAssigneeOptions((Collection)issues, null, (List)suggestedUsers, null, false);
        ArrayList optionsList = Lists.newArrayList();
        for (SelectChild thing : options.getOptions()) {
            if (thing.isOptionGroup()) {
                optionsList.add(this.makeAssigneeOptionGroupData((OptionGroup)thing));
                continue;
            }
            optionsList.add(this.makeAssigneeOptionData((AssigneeOption)thing));
        }
        HashMap values = Maps.newHashMap();
        values.put("assigneeOptions", optionsList);
        values.put("loggedInUserAssignable", options.isLoggedInUserAssignable());
        values.put("totalUsers", this.userManager.getTotalUserCount());
        return new JSONObject((Map)values);
    }

    private Assignees getAssigneesObject() {
        if (this.assignees == null) {
            this.assignees = new Assignees(this.jiraAuthenticationContext, this.applicationProperties, this.assigneeService, this.avatarService, this.userManager, this.emailFormatter);
        }
        return this.assignees;
    }

    private JSONObject makeAssigneeOptionGroupData(OptionGroup group) {
        HashMap values = Maps.newHashMap();
        ArrayList options = Lists.newArrayList();
        for (AssigneeOption assigneeOption : group.getGroupOptions()) {
            options.add(this.makeAssigneeOptionData(assigneeOption));
        }
        values.put("id", group.getId());
        values.put("display", group.getDisplay());
        values.put("footer", group.getFooter());
        values.put("groupOptions", options);
        values.put("optionGroup", group.isOptionGroup());
        values.put("weight", group.getWeight());
        return new JSONObject((Map)values);
    }

    private JSONObject makeAssigneeOptionData(AssigneeOption option) {
        HashMap values = Maps.newHashMap();
        values.put("id", option.getId());
        values.put("avatarURL", option.getAvatarURL());
        values.put("displayName", option.getDisplayName());
        values.put("emailAddress", option.getEmailAddress());
        values.put("loggedInUser", option.isLoggedInUser());
        values.put("optionEnabled", option.isOptionEnabled());
        values.put("optionGroup", option.isOptionGroup());
        values.put("optionName", option.getOptionName());
        values.put("selected", option.isSelected());
        return new JSONObject((Map)values);
    }
}

